<?php

namespace app\controllers;

use app\models\Clientes;
use app\models\ClientesSearch;
use app\models\Facturas;
use app\models\Parametros;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;

/**
 * ClientesController implements the CRUD actions for Clientes model.
 */
class ClientesController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }



    public function beforeAction($action)
    {
        $userModel = Yii::$app->user->identity;

        // Redirige si el usuario no está logueado
        if (Yii::$app->user->isGuest) {
            return $this->redirect(['site/login']);
        }


        if (in_array($action->id,  ['delete'])) {
            if ($userModel->rol !== 'superAdmin') {
                return $this->redirect(['site/access-denied']);
            }
        }


        if (in_array($action->id,  ['index', 'update', 'create'])) {
            if (!in_array($userModel->rol, ['superAdmin', 'vendedor'])) {
                return $this->redirect(['site/access-denied']);
            }
        }

        return parent::beforeAction($action);
    }

    /**
     * Lists all Clientes models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $this->layout = 'dashboard';
        $searchModel = new ClientesSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Clientes model.
     * @param int $cli_id Cli ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($cli_id)
    {
        $this->layout = 'dashboard';
        return $this->render('view', [
            'model' => $this->findModel($cli_id),
        ]);
    }

    /**
     * Creates a new Clientes model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->layout = 'dashboard';
        $model = new Clientes();

        if ($this->request->isPost) {

            $model->created_by = Yii::$app->user->id;
            $model->updated_by = Yii::$app->user->id;
            $model->created_at = date('Y-m-d H:i:s');
            $model->updated_at = date('Y-m-d H:i:s');

            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['index']);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Clientes model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $cli_id Cli ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($cli_id)
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->layout = 'dashboard';
        $model = $this->findModel($cli_id);

        $model->updated_by = Yii::$app->user->id;
        $model->updated_at = date('Y-m-d H:i:s');

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'cli_id' => $model->cli_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Clientes model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $cli_id Cli ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($cli_id)
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL


        $model =  $this->findModel($cli_id);
        $model->cli_estado = Parametros::ELIMINADO;
        $model->save();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Clientes model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $cli_id Cli ID
     * @return Clientes the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($cli_id)
    {
        if (($model = Clientes::findOne(['cli_id' => $cli_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    public function actionGetCliente($identificacion, $factura)
    {
        $resultado = new \stdClass();
        $resultado->resultado = false;


        $cliente = Clientes::find()->where(['cli_identificacion' => $identificacion])->one();
        if (!empty($cliente)) {
            $resultado->data = $cliente->toArray();
            $resultado->resultado = true;
            $resultado->fasdfa = $factura;

            if (!empty($factura)) {
                $factura = Facturas::find()->where(['fac_id' => $factura])->one();
                $factura->cli_id = $cliente->cli_id;
                $factura->save();
            }
        } else {
            $resultado->mensaje = 'Cliente no encontrado';
        }

        return json_encode($resultado);
    }


    public function actionGuardaCliente($identificacion, $nombre, $email, $direccion,  $fono, $celular, $factura)
    {

        $resultado = new \stdClass();
        $resultado->transaccion = false;

        try {

            $cliente = Clientes::find()->where(['cli_identificacion' => $identificacion])->one();


            if (empty($cliente)) {
                $cliente = new Clientes();

                $cliente->created_by = Yii::$app->user->id;
                $cliente->created_at = date('Y-m-d H:i:s');
                $cliente->cli_identificacion = $identificacion;
            }


            $cliente->updated_by = Yii::$app->user->id;
            $cliente->updated_at = date('Y-m-d H:i:s');


            $cliente->cli_nombre = $nombre;
            $cliente->cli_direccion = $direccion;
            $cliente->cli_correo = $email;
            $cliente->cli_telefono = $fono;
            $cliente->cli_celular = $celular;
            $cliente->cli_estado = Parametros::ACTIVO;

            $cliente->cli_tipo_identificacion = strlen($identificacion) == 10 ? Parametros::CEDULA : Parametros::PASAPORTE;



            if ($cliente->save(false)) {

                if ($factura != '') {
                    $factura = Facturas::find()->where(['fac_id' => $factura])->one();
                    $factura->cli_id = $cliente->cli_id;
                    $factura->save(false, ['cli_id']);
                }

                $resultado->transaccion = true;
                $resultado->idCliente = $cliente->cli_id;
            } else {
                $resultado->error = $cliente->getErrors();
            }
        } catch (\Exception $e) {
            // Manejo de errores
            $resultado->error = 'Error al guardar cliente: ' . $e->getMessage();
        }

        // Retornar el resultado en formato JSON
        return json_encode($resultado);
    }
}
