<?php

namespace app\controllers;

use app\models\Detallefacturas;
use app\models\DetallefacturasSearch;
use app\models\Parametros;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * DetallefacturasController implements the CRUD actions for Detallefacturas model.
 */
class DetallefacturasController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }



    /**
     * Lists all Detallefacturas models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $this->layout = 'dashboard';
        $searchModel = new DetallefacturasSearch();

        // Añadir manualmente el parámetro 'det_estado'
        $queryParams = $this->request->queryParams;
        $queryParams['DetallefacturasSearch']['det_estado'] = Parametros::ACTIVO; // Asegúrate de que la clave esté correctamente especificada

        $dataProvider = $searchModel->search($queryParams);


        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }




    /**
     * Displays a single Detallefacturas model.
     * @param int $det_id Det ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($det_id)
    {
        $this->layout = 'dashboard';
        return $this->render('view', [
            'model' => $this->findModel($det_id),
        ]);
    }

    /**
     * Creates a new Detallefacturas model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $this->layout = 'dashboard';
        $model = new Detallefacturas();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'det_id' => $model->det_id]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Detallefacturas model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $det_id Det ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($det_id)
    {
        $this->layout = 'dashboard';
        $model = $this->findModel($det_id);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'det_id' => $model->det_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Detallefacturas model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $det_id Det ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($det_id)
    {
        $this->findModel($det_id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Detallefacturas model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $det_id Det ID
     * @return Detallefacturas the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($det_id)
    {
        if (($model = Detallefacturas::findOne(['det_id' => $det_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
