<?php

namespace app\controllers;

use app\models\Clientes;
use app\models\Detallefacturas;
use app\models\Empresa;
use app\models\Facturas;
use app\models\FacturasSearch;
use app\models\Parametros;
use app\models\Productos;
use app\models\User;
use Exception;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use Mpdf\Mpdf;
use PhpParser\Builder\Param;

/**
 * FacturasController implements the CRUD actions for Facturas model.
 */
class FacturasController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }



    public function beforeAction($action)
    {
        $userModel = Yii::$app->user->identity;
        if (
            $action->id === 'index'
            || $action->id === 'update'
            || $action->id === 'create'
            || $action->id === 'delete'
        ) {
            //Si no esta logueado O no es de tipo admin redirige
            if (Yii::$app->user->isGuest) {
                return $this->redirect(['site/login']);
            } else if ($userModel->rol !== 'superAdmin' && $userModel->rol !== 'vendedor') {
                return $this->redirect(['site/access-denied']);
            }
        }

        return parent::beforeAction($action);
    }

    /**
     * Lists all Facturas models.
     *
     * @return string
     */
    public function actionIndex()
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->layout = 'dashboard';
        $searchModel = new FacturasSearch();


        $queryParams = $this->request->queryParams;
        // $queryParams['FacturasSearch']['fac_tipo']  = [Parametros::NOTA_PEDIDO, Parametros::NOTA_VENTA, '']; // Asegúrate de que la clave esté correctamente especificada

        $dataProvider = $searchModel->search2($queryParams);

        $total = 0;
        $totalEfectivo = 0;
        $totalTransferencia = 0;
        $totalTarjeta = 0;



        $models = $dataProvider->getModels();

        foreach ($models as $model) {
            if ($model->fac_estado == Parametros::FACT_PAGADA) {
                $total = $total + $model->fac_total;

                if ($model->fac_metodo_pago_id == Parametros::EFECTIVO) {
                    $totalEfectivo = $totalEfectivo + $model->fac_total;
                }

                if ($model->fac_metodo_pago_id == Parametros::TRANSFERENCIA) {
                    $totalTransferencia = $totalTransferencia + $model->fac_total;
                }

                if ($model->fac_metodo_pago_id == Parametros::TARJETA) {
                    $totalTarjeta = $totalTarjeta + $model->fac_total;
                }
            }
        }

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'total' => $total,
            'totalEfectivo' => $totalEfectivo,
            'totalTarjeta' => $totalTarjeta,
            'totalTransferencia' => $totalTransferencia,
        ]);
    }




    public function actionSeparados()
    {
        $this->layout = 'dashboard';
        $searchModel = new FacturasSearch();


        $queryParams = $this->request->queryParams;
        $queryParams['FacturasSearch']['fac_tipo'] = Parametros::SEPARADO; // Asegúrate de que la clave esté correctamente especificada

        $dataProvider = $searchModel->search($queryParams);


        $total = 0;
        $totalEfectivo = 0;
        $totalTransferencia = 0;
        $totalTarjeta = 0;



        $models = $dataProvider->getModels();

        foreach ($models as $model) {
            if ($model->fac_estado == Parametros::FACT_PAGADA) {
                $total = $total + $model->fac_total;

                if ($model->fac_metodo_pago_id == Parametros::EFECTIVO) {
                    $totalEfectivo = $totalEfectivo + $model->fac_total;
                }

                if ($model->fac_metodo_pago_id == Parametros::TRANSFERENCIA) {
                    $totalTransferencia = $totalTransferencia + $model->fac_total;
                }

                if ($model->fac_metodo_pago_id == Parametros::TARJETA) {
                    $totalTarjeta = $totalTarjeta + $model->fac_total;
                }
            }
        }

        return $this->render('separados', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
            'total' => $total,
            'totalEfectivo' => $totalEfectivo,
            'totalTarjeta' => $totalTarjeta,
            'totalTransferencia' => $totalTransferencia,
        ]);
    }


    /**
     * Displays a single Facturas model.
     * @param int $fac_id Fac ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($fac_id, $tipo)
    {

        $empresa = Empresa::find()->where(['codigo' => Parametros::empresa])->select(['nombre', 'direccion', 'telefonos', 'logotipo'])->one();
        $factura = Facturas::find()->where(['fac_id' => $fac_id])->one();

        $this->layout = 'dashboard';

        $data = self::getDetalleFacturaPdf($fac_id, $factura->fac_metodo_pago_id);

        // Contenido HTML que se convertirá en PDF


        $cliente= Clientes::find()->where(['cli_id' => $factura->cli_id])->one(); 
        $user = User::find()->where(['id' => $factura->fac_usuario])->one();
        


        $html = $this->renderPartial($tipo, [
            'data' => $data, // Pasas los datos a la vista
            'total' => $factura->fac_total,
            'subtotal' => $factura->fac_subtotal,
            'descuento' => $factura->fac_descuento,
            'cliente' => $cliente->cli_nombre,
            'ci' => $cliente->cli_identificacion,
            'vendedor' => $user->nombre??'',
            'numFactura' => $factura->fac_numero,
            'fecha' => $factura->fac_fecha,
            'empresa' => $empresa->nombre,
            'direccion' => $cliente->cli_direccion??'',
            'fono' => $cliente->cli_telefono ?? ($cliente->cli_celular ?? ''),
            'logo' => Yii::$app->urlManager->baseUrl . '/uploads/images/logoVenta.png'
        ]);

        $mpdf = new \Mpdf\Mpdf([
            'mode' => 'utf-8',
            'format' => [65, 220], // Ancho 70mm, altura dinámica 'auto'
            'margin_left' => 2,    // Márgenes en milímetros
            'margin_right' => 2
        ]);
        

        // Margenes opcionales
        $mpdf->SetMargins(0, 0, 0); // Márgenes: izquierda, derecha, superior

        // Escribir el contenido HTML
        $mpdf->WriteHTML($html);

        // Descargar el archivo PDF o mostrarlo en el navegador
        $mpdf->Output('ticket.pdf', \Mpdf\Output\Destination::INLINE); // INLINE para mostrar en el navegador o 'D' para descargar
    }



    public static function getDetalleFacturaPdf($id, $metodoPago)
    {
        $itemsFactura = [];
        $detalleFacturas = Detallefacturas::find()->where(['fac_id' => $id])->all();


        // Recorremos los detalles de la factura
        foreach ($detalleFacturas as $detalle) {

            $prod = Productos::find()->where(['pro_id' => $detalle->pro_id])->select(['pro_codigo'])->one();


            $detalleFact = [];
            $detalleFact['producto'] = $detalle->det_detalle;
            $detalleFact['codigo'] = $prod->pro_codigo;
            $detalleFact['cantidad'] = $detalle->det_cantidad;
            $detalleFact['pu'] = number_format($metodoPago == Parametros::TARJETA ?  $detalle->det_val_unitario_tarjeta : $detalle->det_val_unitario, 2);
            $detalleFact['dscto'] = number_format($metodoPago == Parametros::TARJETA ?  $detalle->det_descuento_tarjeta : $detalle->det_descuento, 2);
            $detalleFact['subtotal'] = number_format($metodoPago == Parametros::TARJETA ? $detalle->det_subtotal_tarjeta :  $detalle->det_subtotal, 2);

            array_push($itemsFactura, $detalleFact);
        }




        // Retornar el resultado en formato JSON
        return $itemsFactura;
    }

    /**
     * Creates a new Facturas model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {

        $this->layout = 'dashboard';
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL

        //Creamos la factura
        $model = new Facturas();
        $model->fac_estado = Parametros::FACT_IMCOMPLETA;
        $model->fac_numero = '';
        $model->cli_id = 0;
        $model->fac_iva = 0;
        $model->fac_subtotal = 0;
        $model->fac_total = 0;
        $model->fac_metodo_pago_id = 1;
        $model->fac_descuento = 0;
        $model->fac_tipo = Parametros::NOTA_PEDIDO;
        $model->created_by = Yii::$app->user->id;
        $model->updated_by = Yii::$app->user->id;
        $model->fac_usuario = Yii::$app->user->id;
        $model->fac_fecha = date('Y-m-d H:i:s');
        $model->created_at = date('Y-m-d H:i:s');
        $model->updated_at = date('Y-m-d H:i:s');
        $model->save();

        if ($model->save()) {
            return $this->redirect(['update', 'fac_id' => $model->fac_id]);
        }
    }



    public function actionCreateseparado()
    {

        $this->layout = 'dashboard';
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL

        //Creamos la factura
        $model = new Facturas();
        $model->fac_estado = Parametros::FACT_IMCOMPLETA;
        $model->fac_numero = '';
        $model->cli_id = 0;
        $model->fac_iva = 0;
        $model->fac_subtotal = 0;
        $model->fac_total = 0;
        $model->fac_metodo_pago_id = 1;
        $model->fac_descuento = 0;
        $model->fac_tipo = Parametros::SEPARADO;
        $model->created_by = Yii::$app->user->id;
        $model->updated_by = Yii::$app->user->id;
        $model->fac_usuario = Yii::$app->user->id;
        $model->fac_fecha = date('Y-m-d H:i:s');
        $model->created_at = date('Y-m-d H:i:s');
        $model->updated_at = date('Y-m-d H:i:s');
        $model->save();

        if ($model->save()) {
            return $this->redirect(['updateseparado', 'fac_id' => $model->fac_id]);
        }
    }

    /**
     * Updates an existing Facturas model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $fac_id Fac ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($fac_id)
    {
        $this->layout = 'dashboard';
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $model = $this->findModel($fac_id);


        $model->fac_fecha = date('Y-m-d H:i:s');
        $model->updated_at = date('Y-m-d H:i:s');

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'fac_id' => $model->fac_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }




    public function actionUpdateseparado($fac_id)
    {
        $this->layout = 'dashboard';
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $model = $this->findModel($fac_id);


        $model->fac_fecha = date('Y-m-d H:i:s');
        $model->updated_at = date('Y-m-d H:i:s');

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'fac_id' => $model->fac_id]);
        }

        return $this->render('updateseparado', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Facturas model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $fac_id Fac ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($fac_id)
    {

        $resultado = new \stdClass;
        $resultado->transaccion = false;
        date_default_timezone_set('America/Guayaquil'); // Set timezone

        try {

            $model = $this->findModel($fac_id);
            $detalleFacturas = Detallefacturas::find()->where(['fac_id' => $fac_id, 'det_estado' => Parametros::ACTIVO])->all();

            // Check if the total amount is zero
            if ($model->fac_total == 0 && empty($detalleFacturas)) {
                $model->delete();
            } else {
                // If the amount is not 0, change the state
                $model->fac_estado = Parametros::FACT_ANULADA;
                $model->updated_by = Yii::$app->user->id;
                $model->fac_usuario = Yii::$app->user->id;
                $model->updated_at = date('Y-m-d H:i:s');

                //regreso losproductos a percha


                foreach ($detalleFacturas as $detalle) {
                    $cantidadAum = $detalle->det_cantidad;
                    $prod = $detalle->pro_id;
                    $detalle->det_estado = Parametros::INACTIVO;

                    if ($detalle->save()) {
                        $resultado = ProductosController::aumentarProductoStock($prod, $cantidadAum);
                        // $resultado->transaccion = true;
                    } else {
                        $resultado->error = $detalle->getErrors();
                    }
                }

                // Save the changes
                $model->save();
            }
        } catch (\Exception $e) {
            $resultado->error = 'Error al eliminar detalle: ' . $e->getMessage();
        }

        return $this->redirect(['index']);
    }

    /**
     * Finds the Facturas model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $fac_id Fac ID
     * @return Facturas the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($fac_id)
    {
        if (($model = Facturas::findOne(['fac_id' => $fac_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }




    public static function actionGetDetalleFactura($id, $metodoPago)
    {
        $resultado = new \stdClass;
        $resultado->transaccion = false;

        try {
            $detalleFacturas = Detallefacturas::find()->where(['fac_id' => $id, 'det_estado' => Parametros::ACTIVO])->all();

            // Variable para almacenar las filas de la tabla
            $detalleFactHtml = '';

            // Recorremos los detalles de la factura
            foreach ($detalleFacturas as $detalle) {


                $producto = Productos::find()->where(['pro_id' => $detalle->pro_id])->one();

                $codProducto = $producto->pro_codigo ?? '';

                $detalleFactHtml .= "<tr>
                        <td>{$codProducto}</td>
                        <td>{$detalle->det_detalle}</td>
                        <td>{$detalle->det_cantidad}</td>
                        <td>" . number_format($metodoPago == Parametros::TARJETA ? $detalle->det_val_unitario_tarjeta : $detalle->det_val_unitario, 2) . "</td>
                        <td>" . number_format($metodoPago == Parametros::TARJETA ?  $detalle->det_descuento_tarjeta : $detalle->det_descuento, 2) . "</td>
                        <td>" . number_format($metodoPago == Parametros::TARJETA ? $detalle->det_subtotal_tarjeta :  $detalle->det_subtotal, 2) . "</td>
                        <td>
                            <i name='eliminarReg' onclick=\"eliminarRegistro({$detalle->det_id},{$id})\" style='color:grey; cursor: pointer' class='bx bx-trash bx-sm'></i>
                             <i name='modificarReg' onclick=\"menos({$detalle->det_id},{$id})\" style='color:red; cursor: pointer' class='bx bxs-minus-circle bx-sm'></i>
                             <i name='modificarReg' onclick=\"mas({$detalle->det_id},{$id})\" style='color:blue; cursor: pointer' class='bx bxs-plus-circle bx-sm'></i>
                        </td>
                    </tr>";
            }

            // Si todo sale bien, asignamos el HTML generado al resultado
            $resultado->transaccion = true;
            $resultado->detalle = $detalleFactHtml;
        } catch (\Exception $e) {
            // Manejo de errores
            $resultado->error = 'Error al obtener detalle: ' . $e->getMessage();
        }

        // Retornar el resultado en formato JSON
        return json_encode($resultado);
    }



    public function actionGetValoresFact($id, $metodoPago)
    {

        $resultado = new \stdClass;
        $resultado->transaccion = false;

        try {

            $factura = Facturas::find()->where(['fac_id' => $id])->one();
            $detalleFact = Detallefacturas::find()->where(['fac_id' => $id, 'det_estado' => Parametros::ACTIVO])->all();
            $subtotal = 0;
            $dscto = 0;


            if ($metodoPago == Parametros::TARJETA) {
                foreach ($detalleFact as $detalle) {
                    $dscto = $dscto + $detalle->det_descuento_tarjeta;
                    $subtotal = $subtotal + $detalle->det_subtotal_tarjeta + $detalle->det_descuento_tarjeta;
                }
            } else {
                foreach ($detalleFact as $detalle) {
                    $dscto = $dscto + $detalle->det_descuento;
                    $subtotal = $subtotal + $detalle->det_subtotal + $detalle->det_descuento;
                }
            }



            $factura->fac_subtotal = number_format($subtotal, 2);
            $factura->fac_descuento = number_format($dscto, 2);
            $factura->fac_total = number_format($subtotal - $dscto, 2);
            $factura->fac_metodo_pago_id = $metodoPago;


            $resultado->transaccion = true;
            $resultado->data = $factura->toArray();

            if ($factura->save()) {
            } else {
            }
        } catch (\Exception $e) {
            // Manejo de errores
            $resultado->error = 'Error al actualñizar valor fact: ' . $e->getMessage();
        }

        return  json_encode($resultado);
    }


    public static function generaNumFactura()
    {
        $totalFacturas = Facturas::find()->where(['fac_estado' => Parametros::FACT_PAGADA])->count() + 1; // Sumar 1 para que sea el siguiente número
        $numFacturaFormateado = str_pad($totalFacturas, 6, '0', STR_PAD_LEFT);
        $numFactura = '001-001-' . $numFacturaFormateado;
        return $numFactura;
    }



    public static function actionGetDatosCabecera($id)
    {
        $resultado = new \stdClass;
        $resultado->transaccion = false;

        try {


            $factura = Facturas::find()->where(['fac_id' => $id])->one();
            $cliente  = null;

            if (!empty($factura->cli_id)) {
                $cliente = Clientes::find()->where(['cli_id' => $factura->cli_id])->asArray()->one();
            }



            $resultado->transaccion = true;
            $resultado->cliente = $cliente;
            $resultado->formaPago = $factura->fac_metodo_pago_id ?? null;
            $resultado->usuario = $factura->fac_usuario ?? null;
        } catch (\Exception $e) {
            // Manejo de errores
            $resultado->error = 'Error al obtener detalle: ' . $e->getMessage();
        }

        // Retornar el resultado en formato JSON
        return json_encode($resultado);
    }



    public static function actionSaveVendedor($id, $idVendedor)
    {
        $resultado = new \stdClass;
        $resultado->transaccion = false;

        try {


            $factura = Facturas::find()->where(['fac_id' => $id])->one();

            $resultado->transaccion = true;
            $factura->fac_usuario = $idVendedor;
            $factura->save(false, ['fac_usuario']);
        } catch (\Exception $e) {
            // Manejo de errores
            $resultado->error = 'Error al obtener detalle: ' . $e->getMessage();
        }

        // Retornar el resultado en formato JSON
        return json_encode($resultado);
    }


    public static function actionEmitirNota($id, $tipo)
    {
        $resultado = new \stdClass;
        $resultado->transaccion = false;
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL

        try {
            $factura = Facturas::find()->where(['fac_id' => $id])->one();

            $resultado->transaccion = true;
            $factura->fac_fecha = date('Y-m-d H:i:s');

            if ($tipo !== 'separado') {
                $factura->fac_estado = Parametros::FACT_PAGADA;
                $factura->fac_saldo = 0;
            } else {
                $factura->fac_estado = Parametros::FACT_PROCESO;
                $factura->fac_saldo = $factura->fac_total;
            }


            $factura->fac_numero = self::generaNumFactura();

            $factura->fac_tipo = Parametros::NOTA_PEDIDO;
            if ($tipo == 'notaventa') {
                $factura->fac_tipo = Parametros::NOTA_VENTA;
            }

            if ($tipo == 'separado') {
                $factura->fac_tipo = Parametros::SEPARADO;
            }

            if ($factura->save(false, ['fac_fecha', 'fac_estado', 'fac_numero', 'fac_tipo', 'fac_saldo'])) {

                //actu7alizo el vendedor en todos los detalles
                $detalles = Detallefacturas::find()->where(['fac_id' => $factura->fac_id])->all();
                foreach ($detalles as $detalle) {
                    $detalle->id_vendedor = $factura->fac_usuario;
                    if ($detalle->save(false, ['id_vendedor'])) {
                    } else {
                        $resultado->error = $detalle->getErrors();
                    }
                }


                $resultado->transaccion = true;
            } else {
                $resultado->error = $factura->getErrors();
            }
        } catch (\Exception $e) {
            // Manejo de errores
            $resultado->error = 'Error al obtener detalle: ' . $e->getMessage();
        }

        // Retornar el resultado en formato JSON
        return json_encode($resultado);
    }


    public function actionFacturaSeparado($idCliente)
    {


        $this->layout = 'dashboard';
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL

        //Creamos la factura
        $model = new Facturas();
        $model->fac_estado = Parametros::FACT_IMCOMPLETA;
        $model->fac_numero = '';
        $model->cli_id = $idCliente;
        $model->fac_iva = 0;
        $model->fac_subtotal = 0;
        $model->fac_total = 0;
        $model->fac_metodo_pago_id = 1;
        $model->fac_descuento = 0;
        $model->fac_tipo = '';
        $model->created_by = Yii::$app->user->id;
        $model->updated_by = Yii::$app->user->id;
        $model->fac_usuario = Yii::$app->user->id;
        $model->fac_fecha = date('Y-m-d H:i:s');
        $model->created_at = date('Y-m-d H:i:s');
        $model->updated_at = date('Y-m-d H:i:s');


        $model->save();


        if ($model->save()) {



            //agregamos el detalle a la factura
            $detalle = new Detallefacturas();
            $detalle->fac_id = $model->fac_id;
            $detalle->pro_id = $model->fac_id;
            $detalle->pro_id = $model->fac_id;
            $detalle->det_cantidad = 1;
        }
    }
}
