<?php

namespace app\controllers;

use app\models\Metodospago;
use app\models\MetodospagoSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;

/**
 * MetodospagoController implements the CRUD actions for Metodospago model.
 */
class MetodospagoController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all Metodospago models.
     *
     * @return string
     */
    public function actionIndex()
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->layout = 'dashboard';
        $searchModel = new MetodospagoSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Metodospago model.
     * @param int $met_pago_id Met Pago ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($met_pago_id)
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->layout = 'dashboard';
        return $this->render('view', [
            'model' => $this->findModel($met_pago_id),
        ]);
    }

    /**
     * Creates a new Metodospago model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->layout = 'dashboard';
        $model = new Metodospago();

        if ($this->request->isPost) {

            $model->created_by = Yii::$app->user->id;
            $model->updated_by = Yii::$app->user->id;
            $model->created_at = date('Y-m-d H:i:s');
            $model->updated_at = date('Y-m-d H:i:s');
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'met_pago_id' => $model->met_pago_id]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Metodospago model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $met_pago_id Met Pago ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($met_pago_id)
    {
        date_default_timezone_set('America/Guayaquil'); //1:::HORA DE GUAYAQUIL
        $this->layout = 'dashboard';

        $model = $this->findModel($met_pago_id);

        $model->updated_by = Yii::$app->user->id;
        $model->updated_at = date('Y-m-d H:i:s');

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'met_pago_id' => $model->met_pago_id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Metodospago model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $met_pago_id Met Pago ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($met_pago_id)
    {
        $this->findModel($met_pago_id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Metodospago model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $met_pago_id Met Pago ID
     * @return Metodospago the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($met_pago_id)
    {
        if (($model = Metodospago::findOne(['met_pago_id' => $met_pago_id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
