<?php

namespace app\controllers;

use app\models\Modulobase;
use app\models\ModulobaseSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use Yii;
use yii\web\UploadedFile;

/**
 * ModulobaseController implements the CRUD actions for Modulobase model.
 */
class ModulobaseController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }


    public function beforeAction($action)
    {
        if ($action->id === 'index' ||  $action->id === 'create' ||  $action->id === 'view' ||  $action->id === 'update' ||  $action->id === 'delete') {
            if (Yii::$app->user->isGuest) {
                return $this->redirect(['site/access-denied']);
            }
        }

        return parent::beforeAction($action);
    }

    /**
     * Lists all Modulobase models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $this->layout = 'dashboard';
        $searchModel = new ModulobaseSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Modulobase model.
     * @param string $codigo Codigo
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($codigo)
    {
        return $this->render('view', [
            'model' => $this->findModel($codigo),
        ]);
    }

    /**
     * Creates a new Modulobase model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate2()
    {
        $model = new Modulobase();
        $this->layout = 'dashboard';

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'codigo' => $model->codigo]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }


    public function actionCreate()
    {
        $model = new Modulobase();
        $this->layout = 'dashboard';

        if ($model->load(Yii::$app->request->post())) {
            $imagen = UploadedFile::getInstance($model, 'imagen');

            $namePartsImagen = explode(".", $imagen->name);

            if (!is_null($imagen)) {
                $ext = end($namePartsImagen);
                $model->imagen = Yii::$app->security->generateRandomString() . ".{$ext}";
                Yii::$app->params['uploadPath'] = Yii::$app->basePath . '/web/uploads/images/';
                $path = Yii::$app->params['uploadPath'] . $model->imagen;
                $imagen->saveAs($path);
            }

            if ($model->save()) {
                return $this->redirect(['view', 'codigo' => $model->codigo]);
            } else {
                $model->loadDefaultValues();
                var_dump($model->getErrors());
                die();
            }
        }
        return $this->render('create', [
            'model' => $model,
        ]);
    }



    /**
     * Updates an existing Modulobase model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param string $codigo Codigo
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate2($codigo)
    {
        $model = $this->findModel($codigo);
        $this->layout = 'dashboard';

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'codigo' => $model->codigo]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }


    public function actionUpdate($codigo)
    {
        $this->layout = 'dashboard';
        $model = $this->findModel($codigo);

        if ($model->load(Yii::$app->request->post())) {
            $imagen = UploadedFile::getInstance($model, 'imagen');

            $namePartsImagen = explode(".", $imagen->name);

            if (!is_null($imagen)) {
                $ext = end($namePartsImagen);
                $model->imagen = Yii::$app->security->generateRandomString() . ".{$ext}";
                Yii::$app->params['uploadPath'] = Yii::$app->basePath . '/web/uploads/images/';
                $path = Yii::$app->params['uploadPath'] . $model->imagen;
                $imagen->saveAs($path);
            }

            if ($model->save()) {
                return $this->redirect(['view', 'codigo' => $model->codigo]);
            } else {
                $model->loadDefaultValues();
                var_dump($model->getErrors());
                die();
            }
        }
        return $this->render('update', [
            'model' => $model,
        ]);
    }



    /**
     * Deletes an existing Modulobase model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param string $codigo Codigo
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($codigo)
    {
        $this->findModel($codigo)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Modulobase model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param string $codigo Codigo
     * @return Modulobase the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($codigo)
    {
        if (($model = Modulobase::findOne(['codigo' => $codigo])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
