<?php

namespace app\controllers;

use Yii;
use yii\filters\AccessControl;
use yii\web\Controller;
use yii\web\Response;
use yii\filters\VerbFilter;
use app\models\LoginForm;
use app\models\ContactForm;
use app\models\Emprendimientos;
use app\models\Parametros;
use app\models\User;
use Mpdf\Mpdf;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

use function PHPUnit\Framework\returnSelf;

class SiteController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['logout'],
                'rules' => [
                    [
                        'actions' => ['logout'],
                        'allow' => true,
                        'roles' => ['@'],
                    ],
                ],
            ],
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'logout' => ['post'],
                ],
            ],
        ];
    }


    public function beforeAction($action)
    {

        if ($action->id === 'create' ||  $action->id === 'view' ||  $action->id === 'update' ||  $action->id === 'delete' || $action->id === 'register') {
            if (Yii::$app->user->isGuest) {
                return $this->redirect(['site/login']);
            }
        }

        return parent::beforeAction($action);
    }

    /**
     * {@inheritdoc}
     */
    public function actions()
    {
        return [
            'error' => [
                'class' => 'yii\web\ErrorAction',
            ],
            'captcha' => [
                'class' => 'yii\captcha\CaptchaAction',
                'fixedVerifyCode' => YII_ENV_TEST ? 'testme' : null,
            ],
        ];
    }




    /**
     * Displays homepage.
     *
     * @return string
     */




    public function actionIndex()
    {

        $this->layout = 'empty';
        return $this->render('home');

        /*   $this->layout = 'dashboard';
        return $this->render('dashboard'); */
    }

    /**
     * Login action.
     *
     * @return Response|string
     */


    public function actionIngresarDashboard()
    {
        $this->layout = 'dashboard';
        return $this->render('dashboard');
    }


    public function actionLogin()
    {
        if (!Yii::$app->user->isGuest) {
            return $this->redirect(['site/ingresar-dashboard']);
        } else {
            $this->layout = 'login';
            $model = new User();

            if ($model->load(Yii::$app->request->post())) {
                $dataUser = Yii::$app->request->post();
                $user = User::findOne(['username' => $dataUser['User']['username'], 'estado' => Parametros::ACTIVO]);

                if ($user !== null) {
                    if ($user->validatePassword($dataUser['User']['password'])) {
                        if (Yii::$app->user->login($user)) {
                            return $this->redirect(['site/ingresar-dashboard']);
                        } else {
                            Yii::$app->session->setFlash('error', 'No se pudo iniciar sesión por un error desconocido.');
                        }
                    } else {
                        Yii::$app->session->setFlash('error', 'Contraseña incorrecta.');
                    }
                } else {
                    Yii::$app->session->setFlash('error', 'Nombre de usuario no encontrado.');
                }
            }

            return $this->render('login', [
                'model' => $model,
            ]);
        }
    }



    /**
     * Logout action.
     *
     * @return Response
     */
    public function actionLogout()
    {
        Yii::$app->user->logout();
        return $this->redirect(['site/login']);
    }

    /**
     * Displays contact page.
     *
     * @return Response|string
     */
    public function actionContact()
    {
        $model = new ContactForm();
        if ($model->load(Yii::$app->request->post()) && $model->contact(Yii::$app->params['adminEmail'])) {
            Yii::$app->session->setFlash('contactFormSubmitted');

            return $this->refresh();
        }
        return $this->render('contact', [
            'model' => $model,
        ]);
    }

    /**
     * Displays about page.
     *
     * @return string
     */
    public function actionAbout()
    {
        return $this->render('about');
    }


    public function actionRegister()
    {

        $userModel = Yii::$app->user->identity;

        $model = new User();
        $model->empresa = $userModel->empresa;
        $this->layout = 'dashboard';

        if ($model->load(Yii::$app->request->post()) && $model->validate()) {
            $model->setPassword($model->password);
            $model->save(false); // 'false' para evitar validaciones adicionales

            Yii::$app->session->setFlash('success', '¡Registro exitoso!');
            return $this->redirect(['user/index']); // Redirigir a la página de inicio de sesión
        }

        return $this->render('register', [
            'model' => $model,
        ]);
    }


    public static function registerEmprendedor($solicitud)
    {

        $resultado = new \stdClass;
        $resultado->transaccion = false;

        $model = new User();
        $model->username = $solicitud->correo;
        $model->email = $solicitud->correo;
        $model->password = User::createPassword($solicitud->cedula);
        $model->rol = 'emprendedor';
        $model->nombre = $solicitud->nombre;
        $model->estado = 'A';
        $model->id = $solicitud->cedula;
        $model->emprendimiento = str_replace(' ', '', $solicitud->negocio);


        if ($model->save(false)) {
            $resultado->transaccion = true;
            $emprend = new Emprendimientos();
            $emprend->cod_emprendimiento = str_replace(' ', '', $solicitud->negocio);
            $emprend->estado = 'A';
            $emprend->save();
            self::sendEmail($solicitud->nombre, $solicitud->correo, 'Solicitud aprobada', $solicitud->cedula);
        }

        return json_encode($resultado);
    }


    public static  function sendEmail($nombre, $destinatario, $asunto, $cedula)
    {

        $resultado = new \stdClass;
        $resultado->transaccion = false;

        $input = file_get_contents('php://input');
        $data = json_decode($input, true);

        $mail = Yii::$app->mailer->compose();
        $mail->setFrom('seguimientoestudiantes@kailaacademy.com');
        $mail->setTo($destinatario); // Destinatario
        $mail->setSubject('Solicitud Aprobada'); // Asunto
        $mail->setTextBody(''); // Cuerpo del correo en texto plano
        $mail->setHtmlBody('Hola ' . $nombre . ', tu solicitud para unirte a INAN emprende ha sido aprobada. A partir de este momento puedes personalizar tu página web accediendo a la siguiente url <a href="<font color="blue">https://tecnologicoinan.edu.ec/web/index.php?r=site%2Flogin</font>">Panel de administración</a>. Deberás emplear tu email como usuario y tu número de cédula como contraseña.');


        if ($mail->send()) {
            $resultado->transaccion = true;
        } else {
            $resultado->error = 'Hubo un error al enviar el correo: ' . $mail->ErrorInfo;
        }


        return json_encode($resultado);
    }


    public function actionAccessDenied()
    {
        $this->layout = 'error';
        return $this->render('accesodenegado');
    }



    public function actionGenerarReporte()
    {

        $data = file_get_contents('php://input');

        // Crear una nueva instancia de la clase Spreadsheet
        $spreadsheet = new Spreadsheet();

        // Obtener la hoja activa
        $sheet = $spreadsheet->getActiveSheet();

        // Escribir el encabezado en la primera fila
        $col = 'A';
        foreach ($data->encabezado as $item) {
            $sheet->setCellValue($col . '1', $item);
            $col++;
        }

        // Establecer algunos estilos para el encabezado
        $styleArray = [
            'font' => [
                'bold' => true,
            ],
            'borders' => [
                'top' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                ],
            ],
        ];
        $sheet->getStyle('A1:' . $col . '1')->applyFromArray($styleArray);

        // Escribir los datos en el cuerpo del archivo
        $row = 2; // Empezar desde la segunda fila
        foreach ($data->data as $row_data) {
            $col = 'A';
            foreach ($row_data as $item) {
                $sheet->setCellValue($col . $row, $item);
                $col++;
            }
            $row++;
        }

        // Crear un objeto Writer
        $writer = new Xlsx($spreadsheet);

        // Definir la cabecera para que el navegador entienda que se está descargando un archivo Excel
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $nomDocumento . '.xlsx"');
        header('Cache-Control: max-age=0');

        // Guardar el archivo en el buffer de salida
        $writer->save('php://output');

        // Detener la ejecución del script después de enviar el archivo
        exit();
    }


    public function actionGenerarFactura()
    {

        $data = [
            ['producto' => 'Café Americano', 'cantidad' => 2, 'precio' => 1.50],
            ['producto' => 'Sandwich Jamón', 'cantidad' => 1, 'precio' => 2.00],
            ['producto' => 'Jugo de Naranja', 'cantidad' => 1, 'precio' => 1.75],
        ];

        // Contenido HTML que se convertirá en PDF
        $html = $this->renderPartial('notaventa', [
            'data' => $data, // Pasas los datos a la vista
            'total' => 25
        ]);

        // Configurar el tamaño del papel con un ancho fijo y longitud ajustable automáticamente
        $mpdf = new Mpdf([
            'mode' => 'utf-8',
            'format' => [80, 200], // Ancho 80mm, altura dinámica 'auto'
            'margin_left' => 7,       // Márgenes en números
            'margin_right' => 7,
            'margin_top' => 30,
        ]);

        // Margenes opcionales
        $mpdf->SetMargins(0, 0, 0); // Márgenes: izquierda, derecha, superior

        // Escribir el contenido HTML
        $mpdf->WriteHTML($html);

        // Descargar el archivo PDF o mostrarlo en el navegador
        $mpdf->Output('ticket.pdf', \Mpdf\Output\Destination::INLINE); // INLINE para mostrar en el navegador o 'D' para descargar
    }


    public function actionError()
    {
        $exception = Yii::$app->errorHandler->exception;
        
        if ($exception !== null) {
            if ($exception->statusCode == 404) {
                return $this->render('error404', ['exception' => $exception]);
            } else {
                return $this->render('error', ['exception' => $exception]);
            }
        }
    }


}
