<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "catalogo".
 *
 * @property string $codigo
 * @property string $producto
 * @property string $estado
 */
class Catalogo extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'catalogo';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['codigo', 'producto', 'estado'], 'required'],
            [['codigo'], 'string', 'max' => 10],
            [['producto'], 'string', 'max' => 40],
            [['estado'], 'string', 'max' => 1],
            [['codigo'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'codigo' => 'Codigo',
            'producto' => 'Producto',
            'estado' => 'Estado',
        ];
    }
}
