<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Clientes;

/**
 * ClientesSearch represents the model behind the search form of `app\models\Clientes`.
 */
class ClientesSearch extends Clientes
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['cli_id', 'created_by', 'updated_by'], 'integer'],
            [['cli_identificacion', 'cli_nombre', 'cli_direccion', 'cli_correo', 'cli_telefono', 'cli_estado', 'cli_celular', 'cli_tipo_identificacion', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Clientes::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'cli_id' => $this->cli_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'cli_estado' => Parametros::ESTADOS_VALIDOS,
        ]);

        $query->andFilterWhere(['like', 'cli_identificacion', $this->cli_identificacion])
            ->andFilterWhere(['like', 'cli_nombre', $this->cli_nombre])
            ->andFilterWhere(['like', 'cli_direccion', $this->cli_direccion])
            ->andFilterWhere(['like', 'cli_correo', $this->cli_correo])
            ->andFilterWhere(['like', 'cli_telefono', $this->cli_telefono])
            ->andFilterWhere(['like', 'cli_estado', $this->cli_estado])
            ->andFilterWhere(['like', 'cli_celular', $this->cli_celular])
            ->andFilterWhere(['like', 'cli_tipo_identificacion', $this->cli_tipo_identificacion]);

        return $dataProvider;
    }
}
