<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "colores".
 *
 * @property int $col_id
 * @property string $col_nombre
 * @property string $col_estado
 * @property string $created_at
 * @property int $updated_by
 * @property int $created_by
 * @property string $updated_at
 */
class Colores extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'colores';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['col_nombre', 'col_estado', 'created_at', 'updated_by', 'created_by', 'updated_at'], 'required'],
            [['created_at', 'updated_at'], 'safe'],
            [['updated_by', 'created_by'], 'integer'],
            [['col_nombre'], 'string', 'max' => 100],
            [['col_estado'], 'string', 'max' => 1],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'col_id' => 'Col ID',
            'col_nombre' => 'Color',
            'col_estado' => 'Estado',
            'created_at' => 'Fecha creación',
            'updated_at' => 'Fecha actualización',
            'created_by' => 'Creado por',
            'updated_by' => 'Actualizado por',
        ];
    }
}
