<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Colores;

/**
 * ColoresSearch represents the model behind the search form of `app\models\Colores`.
 */
class ColoresSearch extends Colores
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['col_id', 'updated_by', 'created_by'], 'integer'],
            [['col_nombre', 'col_estado', 'created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Colores::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'col_id' => $this->col_id,
            'created_at' => $this->created_at,
            'updated_by' => $this->updated_by,
            'created_by' => $this->created_by,
            'updated_at' => $this->updated_at,
            'updated_at' => $this->updated_at,
            'col_estado' => Parametros::ESTADOS_VALIDOS,
        ]);

        $query->andFilterWhere(['like', 'col_nombre', $this->col_nombre])
            ->andFilterWhere(['like', 'col_estado', $this->col_estado]);

        return $dataProvider;
    }
}
