<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "detallefacturas".
 *
 * @property int $det_id
 * @property int $fac_id
 * @property int $pro_id
 * @property int $det_cantidad
 * @property float $det_val_unitario
 * @property float $det_descuento
 * @property float $det_subtotal
 * @property string $created_at
 * @property string $updated_at
 * @property int $created_by
 * @property int $updated_by
 */
class Detallefacturas extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'detallefacturas';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['fac_id', 'pro_id', 'det_cantidad', 'det_val_unitario', 'det_descuento', 'det_subtotal', 'det_detalle', 'pro_codigo'], 'required'],
            [['fac_id', 'pro_id', 'det_cantidad', 'created_by', 'updated_by'], 'integer'],
            [['det_val_unitario', 'det_descuento', 'det_subtotal', 'det_val_unitario', 'det_descuento_tarjeta', 'det_subtotal_tarjeta', 'det_val_unitario_tarjeta'], 'number'],
            [['created_at', 'updated_at', 'id_vendedor'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'det_id' => 'Det ID',
            'fac_id' => 'Fac ID',
            'pro_id' => 'Pro ID',
            'pro_codigo' => 'Cod. Producto',
            'det_cantidad' => 'Det Cantidad',
            'det_val_unitario' => 'Det Val Unitario',
            'det_descuento' => 'Det Descuento',
            'det_subtotal' => 'Det Subtotal',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'id_vendedor' => 'Vendedor'
        ];
    }
}
