<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Detallefacturas;

/**
 * DetallefacturasSearch represents the model behind the search form of `app\models\Detallefacturas`.
 */
class DetallefacturasSearch extends Detallefacturas
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['det_id', 'fac_id', 'pro_id', 'det_cantidad', 'created_by', 'updated_by', 'det_val_unitario'], 'integer'],
            [['det_val_unitario', 'det_descuento', 'det_subtotal', 'det_descuento_tarjeta', 'det_subtotal_tarjeta', 'det_val_unitario_tarjeta'], 'number'],
            [['created_at', 'updated_at', 'det_detalle', 'pro_codigo', 'id_vendedor', 'det_estado'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Detallefacturas::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'det_id' => $this->det_id,
            'fac_id' => $this->fac_id,
            'pro_id' => $this->pro_id,
            'det_estado' => $this->det_estado,
            'pro_codigo' => $this->pro_codigo,
            'det_cantidad' => $this->det_cantidad,
            'det_detalle' => $this->det_detalle,
            'det_val_unitario' => $this->det_val_unitario,
            'det_descuento' => $this->det_descuento,
            'det_subtotal' => $this->det_subtotal,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'id_vendedor' => $this->id_vendedor,
        ]);


        return $dataProvider;
    }
}
