<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Detalleseparados;

/**
 * DetalleseparadosSearch represents the model behind the search form of `app\models\Detalleseparados`.
 */
class DetalleseparadosSearch extends Detalleseparados
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['det_id', 'fac_id'], 'integer'],
            [['fecha'], 'safe'],
            [['monto', 'saldo'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Detalleseparados::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'det_id' => $this->det_id,
            'fac_id' => $this->fac_id,
            'fecha' => $this->fecha,
            'monto' => $this->monto,
            'saldo' => $this->saldo,
        ]);

        return $dataProvider;
    }
}
