<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "facturas".
 *
 * @property int $fac_id
 * @property string $fac_numero
 * @property int $cli_id
 * @property string $fac_fecha
 * @property float $fac_subtotal
 * @property float $fac_iva
 * @property float $fac_total
 * @property string $fac_estado
 * @property int $fac_metodo_pago_id
 * @property float $fac_descuento
 * @property int $fact_usuario
 * @property string $created_at
 * @property string $updated_at
 * @property int $created_by
 * @property int $updated_by
 */
class Facturas extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'facturas';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [[], 'required'],
            [['cli_id', 'fac_metodo_pago_id', 'created_by', 'updated_by'], 'integer'],
            [['fac_fecha', 'created_at', 'updated_at', 'fac_usuario', 'fac_numero', 'fac_tipo', 'fac_saldo'], 'safe'],
            [['fac_subtotal', 'fac_iva', 'fac_total', 'fac_descuento', 'fac_saldo'], 'number'],
            [['fac_numero'], 'string', 'max' => 50],
            [['fac_estado'], 'string', 'max' => 30],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'fac_id' => 'Fac ID',
            'fac_numero' => 'Número de Factura',
            'cli_id' => 'CI/RUC Cliente',
            'fac_fecha' => 'Fecha',
            'fac_subtotal' => 'Subtotal',
            'fac_iva' => 'Iva',
            'fac_total' => 'Total',
            'fac_estado' => 'Estado',
            'fac_metodo_pago_id' => 'Metodo Pago',
            'fac_descuento' => 'Descuento',
            'fac_tipo' => 'Tipo emisión',
            'fac_usuario' => 'Vendedor',
            'created_at' => 'Fecha creación',
            'updated_at' => 'Fecha actualización',
            'created_by' => 'Creado por',
            'updated_by' => 'Actualizado por',
        ];
    }
}
