<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Facturas;
use Yii;

/**
 * FacturasSearch represents the model behind the search form of `app\models\Facturas`.
 */
class FacturasSearch extends Facturas
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['fac_id', 'cli_id', 'fac_metodo_pago_id',  'created_by', 'updated_by'], 'integer'],
            [['fac_numero', 'fac_fecha', 'fac_estado', 'created_at', 'updated_at', 'fac_usuario', 'fac_tipo', 'fac_saldo'], 'safe'],
            [['fac_subtotal', 'fac_iva', 'fac_total', 'fac_descuento'], 'number'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Facturas::find();

        if (empty($this->fac_fecha)) {
            $this->fac_fecha = date('Y-m-d');  // Fecha actual en formato YYYY-MM-DD
        }

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }



        if (!empty($this->fac_fecha)) {
          //  list($start_date, $end_date) = explode(' a ', $this->fac_fecha);

            // Agregar segundos para incluir el final del día en $end_date
           // $end_date .= ' 23:59:59';

           // $query->andFilterWhere(['between', 'fac_fecha', $start_date, $end_date]);

           $query->andFilterWhere([
                'DATE(fac_fecha)' => $this->fac_fecha, // Filtra solo por la fecha, no la hora
            ]);
        }



        // grid filtering conditions
        $query->andFilterWhere([
            'fac_id' => $this->fac_id,
            'cli_id' => $this->cli_id,
            //  'fac_fecha' => $this->fac_fecha,
            'fac_subtotal' => $this->fac_subtotal,
            'fac_iva' => $this->fac_iva,
            'fac_tipo' => $this->fac_tipo,
            'fac_total' => $this->fac_total,
            'fac_metodo_pago_id' => $this->fac_metodo_pago_id,
            'fac_descuento' => $this->fac_descuento,
            'fac_usuario' => $this->fac_usuario,
            //   'created_at' => $this->created_at,
            //   'updated_at' => $this->updated_at,
            //   'created_by' => $this->created_by,
            //  'updated_by' => $this->updated_by,
        ]);

        $query->andFilterWhere(['like', 'fac_numero', $this->fac_numero])
            ->andFilterWhere(['like', 'fac_estado', $this->fac_estado])
            ->andFilterWhere(['like', 'fac_tipo', $this->fac_tipo]);

        return $dataProvider;
    }



    public function search2($params)
    {
        $query = Facturas::find();
        $userModel = Yii::$app->user->identity;
        $esAdmin = false;

        if (!empty($userModel->rol) && $userModel->rol === 'superAdmin') {
            $esAdmin = true;
        }

        if (empty($this->fac_fecha)) {
            $this->fac_fecha = date('Y-m-d');  // Fecha actual en formato YYYY-MM-DD
        }

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }



        if (!empty($this->fac_fecha)) {
          //  list($start_date, $end_date) = explode(' a ', $this->fac_fecha);

            // Agregar segundos para incluir el final del día en $end_date
        //    $end_date .= ' 23:59:59';

          //  $query->andFilterWhere(['between', 'fac_fecha', $start_date, $end_date]);

          $query->andFilterWhere([
            'DATE(fac_fecha)' => $this->fac_fecha, // Filtra solo por la fecha, no la hora
        ]);
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'fac_id' => $this->fac_id,
            'cli_id' => $this->cli_id,
            //  'fac_fecha' => $this->fac_fecha,
            'fac_subtotal' => $this->fac_subtotal,
            'fac_iva' => $this->fac_iva,
            // 'fac_tipo' => $this->fac_tipo,
            'fac_total' => $this->fac_total,
            'fac_metodo_pago_id' => $this->fac_metodo_pago_id,
            'fac_descuento' => $this->fac_descuento,
            
        ]);

        $query->andFilterWhere(['like', 'fac_numero', $this->fac_numero])
            ->andFilterWhere(['like', 'fac_estado', $this->fac_estado])
            ->andFilterWhere(['in', 'fac_tipo', [Parametros::NOTA_PEDIDO, Parametros::NOTA_VENTA]]);

        if($esAdmin){
            $query->andFilterWhere(['fac_usuario' => $this->fac_usuario]);
        }else{
            $query->andFilterWhere(['fac_usuario' => $userModel->id]);
        }

        $query->orderBy(['fac_fecha' => SORT_DESC]);

        return $dataProvider;
    }
}
