<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Jornadas;

/**
 * JornadasSearch represents the model behind the search form of `app\models\Jornadas`.
 */
class JornadasSearch extends Jornadas
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_jornada', 'created_by', 'id_instituto', 'updated_by'], 'integer'],
            [['nombre_jornada', 'created_at', 'updated_at', 'codigo'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Jornadas::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'id_jornada' => $this->id_jornada,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ]);

        $query->andFilterWhere(['like', 'nombre_jornada', $this->nombre_jornada]);

        return $dataProvider;
    }
}
