<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "metodospago".
 *
 * @property int $met_pago_id
 * @property string $met_pago_nombre
 * @property string $met_pago_estado
 * @property string $created_at
 * @property string $updated_at
 * @property int $created_by
 * @property int $updated_by
 */
class Metodospago extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'metodospago';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['met_pago_nombre', 'met_pago_estado', 'created_at', 'updated_at', 'created_by', 'updated_by'], 'required'],
            [['created_at', 'updated_at'], 'safe'],
            [['created_by', 'updated_by'], 'integer'],
            [['met_pago_nombre'], 'string', 'max' => 100],
            [['met_pago_estado'], 'string', 'max' => 1],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'met_pago_id' => 'Met Pago ID',
            'met_pago_nombre' => 'Nombre',
            'met_pago_estado' => 'Estado',
            'created_at' => 'Fecha creación',
            'updated_at' => 'Fecha actualización',
            'created_by' => 'Creado por',
            'updated_by' => 'Actualizado por',
        ];
    }
}
