<?php

namespace app\models;

use Yii;


/**
 * This is the model class for table "productos".
 *
 * @property int $pro_id
 * @property string $pro_nombre
 * @property string $pro_codigo
 * @property int $prov_id
 * @property string $pro_foto
 * @property int $pro_talla
 * @property int $cat_id
 * @property string $pro_modelo
 * @property int $pro_color
 * @property float $pro_costo
 * @property float $pro_pvp
 * @property int $pro_dscto
 * @property string $pro_descripcion
 * @property int $pro_marca
 * @property string $pro_estado
 * @property int $pro_cant_min_desct
 * @property float $pro_porc_dscto
 * @property int $pro_stock
 * @property string $created_at
 * @property string $updated_at
 * @property int $created_by
 * @property int $updated_by
 */
class Productos extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'productos';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['pro_nombre', 'pro_codigo',    'pro_costo', 'pro_pvp', 'pro_dscto',  'pro_estado', 'pro_stock', 'created_at', 'updated_at', 'created_by', 'updated_by', 'pro_pvp_tarjeta'], 'required'],
            [['prov_id', 'cat_id', 'pro_color', 'pro_marca', 'pro_cant_min_desct', 'pro_stock', 'created_by', 'updated_by'], 'integer'],
            [['pro_costo', 'pro_pvp', 'pro_porc_dscto', 'pro_pvp_tarjeta'], 'number'],

            [['pro_pvp', 'pro_pvp_tarjeta'], 'validatePvpGreaterThanCosto'],

            [['pro_porc_dscto', 'pro_cant_min_desct'], 'required', 'when' => function ($model) {
                return $model->pro_dscto == 1;
            }, 'whenClient' => "function (attribute, value) {
                return $('#model-pro_dscto').is(':checked');
            }", 'message' => 'Este campo es obligatorio cuando se aplica descuento.'],


            [['pro_descripcion'], 'string'],
            [['created_at', 'updated_at', 'pro_aumentar_stock'], 'safe'],
            [['pro_nombre', 'pro_modelo'], 'string', 'max' => 300],
            [['pro_codigo'], 'string', 'max' => 100],
            [['pro_foto'], 'string', 'max' => 300],
            [['pro_estado'], 'string', 'max' => 1],
        ];
    }


    public function validatePvpGreaterThanCosto($attribute, $params)
    {
        if ($this->$attribute < $this->pro_costo) {
            $this->addError($attribute, 'El ' . $attribute . ' no puede ser menor que el costo.');
        }
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'pro_id' => 'Pro ID',
            'pro_nombre' => 'Producto',
            'pro_codigo' => 'Código',
            'prov_id' => 'Proveedor',
            'pro_foto' => 'Foto',
            'pro_talla' => 'Talla',
            'cat_id' => 'Categoria',
            'pro_modelo' => 'Modelo',
            'pro_color' => 'Color',
            'pro_costo' => 'Costo',

            'pro_pvp' => 'P.V.P. Efectivo (Transferencia)',

            'pro_pvp_tarjeta' => 'P.V.P. Tarjeta ',
            'pro_dscto' => 'Aplicar Descuento',
            'pro_descripcion' => 'Descripción',
            'pro_marca' => 'Marca',
            'pro_estado' => 'Estado',
            'pro_cant_min_desct' => 'Cantidad Mínima de productos para recibir Descto',
            'pro_porc_dscto' => 'Porcentaje Dscto (%) solo ingrese el valor',
            'pro_stock' => 'Stock',
            'created_at' => 'Fecha creación',
            'updated_at' => 'Fecha actualización',
            'created_by' => 'Creado por',
            'updated_by' => 'Actualizado por',
        ];
    }
}
