<?php

namespace app\models;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use app\models\Proveedores;

/**
 * ProveedoresSearch represents the model behind the search form of `app\models\Proveedores`.
 */
class ProveedoresSearch extends Proveedores
{
    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['prov_id',  'created_by', 'updated_by'], 'integer'],
            [['prov_identificacion', 'prov_nombre', 'prov_direccion', 'prov_correo', 'prov_telefono', 'prov_estado', 'created_at', 'updated_at', 'prov_tipo_identificacion'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function scenarios()
    {
        // bypass scenarios() implementation in the parent class
        return Model::scenarios();
    }

    /**
     * Creates data provider instance with search query applied
     *
     * @param array $params
     *
     * @return ActiveDataProvider
     */
    public function search($params)
    {
        $query = Proveedores::find();

        // add conditions that should always apply here

        $dataProvider = new ActiveDataProvider([
            'query' => $query,
        ]);

        $this->load($params);

        if (!$this->validate()) {
            // uncomment the following line if you do not want to return any records when validation fails
            // $query->where('0=1');
            return $dataProvider;
        }

        // grid filtering conditions
        $query->andFilterWhere([
            'prov_id' => $this->prov_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'prov_estado' => Parametros::ESTADOS_VALIDOS,
        ]);

        $query->andFilterWhere(['like', 'prov_identificacion', $this->prov_identificacion])
            ->andFilterWhere(['like', 'prov_nombre', $this->prov_nombre])
            ->andFilterWhere(['like', 'prov_direccion', $this->prov_direccion])
            ->andFilterWhere(['like', 'prov_correo', $this->prov_correo])
            ->andFilterWhere(['like', 'prov_telefono', $this->prov_telefono])
            ->andFilterWhere(['like', 'prov_estado', $this->prov_estado]);

        return $dataProvider;
    }
}
