<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "recursos_por_grado".
 *
 * @property int $id_recurso_grado
 * @property int|null $id_recurso
 * @property int|null $id_grado
 * @property int $cantidad_asignada
 * @property int|null $created_by
 * @property int|null $updated_by
 * @property string|null $created_at
 * @property string|null $updated_at
 */
class RecursosPorGrado extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'recursos_por_grado';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['id_recurso', 'id_grado', 'cantidad_asignada'], 'integer'],
            [['created_by', 'updated_by'],  'string', 'max' => 10],
            [['cantidad_asignada'], 'required'],
            [['created_at', 'updated_at'], 'safe'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id_recurso_grado' => 'Id Recurso Grado',
            'id_recurso' => 'Id Recurso',
            'id_grado' => 'Id Grado',
            'cantidad_asignada' => 'Cantidad Asignada',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_at' => 'Created At',
            'updated_at' => 'Updated At',
        ];
    }
}
