<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "solicitudes".
 *
 * @property int $id
 * @property string $fecha
 * @property string $nombre
 * @property string $celular
 * @property string $tipo
 * @property string $comentario
 * @property string $dirección
 * @property string $respuesta
 * @property string $responsable
 * @property string $estado
 */
class Solicitudes extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'solicitudes';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['fecha', 'nombre', 'celular', 'tipo'], 'required'],
            [['fecha'], 'safe'],
            [['comentario', 'respuesta'], 'string'],
            [['nombre'], 'string', 'max' => 100],
            [['celular', 'tipo'], 'string', 'max' => 10],
            [['dirección'], 'string', 'max' => 500],
            [['responsable'], 'string', 'max' => 30],
            [['estado'], 'string', 'max' => 20],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'fecha' => 'Fecha',
            'nombre' => 'Nombre solicitante',
            'celular' => 'Celular',
            'tipo' => 'Tipo',
            'comentario' => 'Comentario',
            'dirección' => 'Dirección',
            'respuesta' => 'Respuesta',
            'responsable' => 'Responsable',
            'estado' => 'Estado',
        ];
    }
}
