<?php

use app\models\Parametros;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var app\models\Clientes $model */
/** @var yii\widgets\ActiveForm $form */
?>

<div class="clientes-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6">

            <div class="card mb-4">
                <h5 class="card-header">Datos personales</h5>
                <div class="card-body">
                    <div>

                        <?= $form->field($model, 'cli_tipo_identificacion')->dropDownList(
                            [Parametros::CEDULA => 'Cédula', Parametros::RUC => 'RUC'],
                            ['disabled' => !$model->isNewRecord]
                        ) ?>


                        <?= $form->field($model, 'cli_identificacion')->textInput(['maxlength' => true, 'readonly' => !$model->isNewRecord]) ?>


                        <?= $form->field($model, 'cli_nombre')->textInput(['maxlength' => true]) ?>

                        <?= $form->field($model, 'cli_direccion')->textInput(['maxlength' => true]) ?>

                        <?= $form->field($model, 'cli_correo')->textInput(['maxlength' => true]) ?>

                        <?= $form->field($model, 'cli_telefono')->textInput(['maxlength' => true]) ?>


                        <?= $form->field($model, 'cli_celular')->textInput(['maxlength' => true]) ?>


                        <?= $form->field($model, 'cli_estado')->dropDownList([Parametros::ACTIVO => 'Activo', Parametros::INACTIVO => 'Inactivo']) ?>



                    </div>
                </div>
            </div>

        </div>


    </div>


    <div class="form-group">
        <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>