<?php

use app\models\Clientes;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use Yii;

/** @var yii\web\View $this */
/** @var app\models\ClientesSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Clientes';
$this->params['breadcrumbs'][] = $this->title;

$userModel = Yii::$app->user->identity;
$esAdmin = false;
if (!empty($userModel->rol) && $userModel->rol === 'superAdmin') {
    $esAdmin = true;
}


?>
<div class="clientes-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Agregar Cliente', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); 
    ?>

    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">

                            <?= GridView::widget([
                                'dataProvider' => $dataProvider,
                                'filterModel' => $searchModel,
                                'columns' => [
                                    ['class' => 'yii\grid\SerialColumn'],

                                    //   'cli_id',
                                    'cli_identificacion',
                                    'cli_nombre',
                                    'cli_direccion',
                                    'cli_correo',
                                    //'cli_telefono',
                                    //'cli_estado',
                                    'cli_celular',
                                    //'cli_tipo_identificacion',
                                    //'created_at',
                                    //'updated_at',
                                    //'created_by',
                                    //'updated_by',
                                    [
                                        'class' => ActionColumn::className(),
                                        'urlCreator' => function ($action, Clientes $model, $key, $index, $column) {
                                            return Url::toRoute([$action, 'cli_id' => $model->cli_id]);
                                        },
                                        'visibleButtons' => [ // Configurar la visibilidad de los botones según la variable $admin

                                            'delete' => function ($model, $key, $index) use ($esAdmin) {
                                                return $esAdmin; // Solo muestra el botón si $admin es true
                                            },
                                        ],
                                        'buttons' => [
                                            'delete' => function ($url, $model, $key) {
                                                return Html::a('<i class="fas fa-trash"></i>', $url, [
                                                    'title' => Yii::t('app', 'Eliminar'), // Título del botón (opcional)
                                                    'data-confirm' => '¿Estás seguro de que deseas eliminar este elemento?', // Mensaje en español
                                                    'data-method' => 'post', // Método para eliminar
                                                    'data-pjax' => '0', // Si usas Pjax, esto previene la actualización por Ajax
                                                ]);
                                            },
                                        ],
                                    ],
                                ],
                            ]); ?>


                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>






</div>