<?php

use app\models\Parametros;
use app\models\User;
use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var app\models\Clientes $model */

$this->title = $model->cli_id;
$this->params['breadcrumbs'][] = ['label' => 'Clientes', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="clientes-view">



    <p>
        <?= Html::a('Actualizar', ['update', 'cli_id' => $model->cli_id], ['class' => 'btn btn-success btn-sm']) ?>

    </p>


    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">

                            <?= DetailView::widget([
                                'model' => $model,
                                'attributes' => [
                                    //    'cli_id',
                                    'cli_identificacion',
                                    'cli_nombre',
                                    'cli_direccion',
                                    'cli_correo',
                                    'cli_telefono',


                                    [
                                        'attribute' => 'cli_estado',
                                        'value' => function ($model) {
                                            return $model->cli_estado === Parametros::ACTIVO ? 'Activo' : 'Inactivo';
                                        },

                                    ],

                                    'cli_celular',

                                    'created_at',
                                    'updated_at',



                                    [
                                        'attribute' => 'created_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->created_by])->one();
                                            return $user->nombre;
                                        },

                                    ],
                                    [
                                        'attribute' => 'updated_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->updated_by])->one();
                                            return $user->nombre;
                                        },

                                    ]


                                ],
                            ]) ?>



                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>



</div>