<?php

use app\models\Parametros;
use app\models\User;
use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var app\models\Colores $model */

$this->title = $model->col_id;
$this->params['breadcrumbs'][] = ['label' => 'Colores', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="colores-view">


    <p>
        <?= Html::a('Actualizar', ['update', 'col_id' => $model->col_id], ['class' => 'btn btn-success btn-sm']) ?>
    </p>


    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">

                            <?= DetailView::widget([
                                'model' => $model,
                                'attributes' => [
                                    // 'col_id',
                                    'col_nombre',
                                    //'col_estado',
                                    [
                                        'attribute' => 'col_estado',
                                        'value' => function ($model) {
                                            return $model->col_estado === Parametros::ACTIVO ? 'Activo' : 'Inactivo';
                                        },

                                    ],
                                    'created_at',
                                    'updated_by',
                                    [
                                        'attribute' => 'created_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->created_by])->one();
                                            return $user->nombre;
                                        },

                                    ],
                                    [
                                        'attribute' => 'updated_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->updated_by])->one();
                                            return $user->nombre;
                                        },

                                    ],
                                ],
                            ]) ?>


                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>



</div>