<?php

use app\models\Detallefacturas;
use app\models\Facturas;
use app\models\Productos;
use app\models\User;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var app\models\DetallefacturasSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Productos vendidos';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="detallefacturas-index">

    <h1><?= Html::encode($this->title) ?></h1>



    <?php // echo $this->render('_search', ['model' => $searchModel]); 
    ?>



    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">

                            <?= GridView::widget([
                                'dataProvider' => $dataProvider,
                                'filterModel' => $searchModel,
                                'columns' => [
                                    ['class' => 'yii\grid\SerialColumn'],

                                    //   'det_id',
                                    'created_at',
                                    //   'fac_id',
                                    // 'pro_id',
                                    'pro_codigo',
                                    [
                                        'attribute' => '',
                                        'format' => 'raw',
                                        'label' => 'Img Producto',
                                        'value' => function ($model) {

                                            $producto = Productos::find()->where(['pro_codigo' => $model->pro_codigo])->select(['pro_foto'])->one();

                                            if (!empty($producto->pro_foto)) {
                                                return '<img 
                                                style="border-radius: 10px; max-height: 100px; width: auto" 
                                                class="card-img-top img-fluid carrera-img" 
                                                src="' . Yii::$app->urlManager->baseUrl . '/uploads/images/' . $producto->pro_foto . '" 
                                                alt="">';
                                            }

                                            return '';
                                        },

                                    ],
                                    'det_detalle',
                                    'det_cantidad',
                                    'det_val_unitario',


                                    [
                                        'attribute' => 'id_vendedor',
                                        'label' => 'Vendedor',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->id_vendedor])->one();
                                            return $user->nombre ?? '';
                                        },

                                    ],




                                    //'det_descuento',
                                    //'det_subtotal',

                                    //'updated_at',
                                    //'created_by',
                                    //'updated_by',


                                ],
                            ]); ?>

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>




</div>