<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var app\models\Detallefacturas $model */

$this->title = $model->det_id;
$this->params['breadcrumbs'][] = ['label' => 'Detallefacturas', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="detallefacturas-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'det_id' => $model->det_id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'det_id' => $model->det_id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => '¿Estás seguro que deseas eliminar este item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'det_id',
            'fac_id',
            'pro_id',
            'det_cantidad',
            'det_val_unitario',
            'det_descuento',
            'det_subtotal',
            'created_at',
            'updated_at',
            'created_by',
            'updated_by',
        ],
    ]) ?>

</div>