<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\file\FileInput;
use dosamigos\ckeditor\CKEditor;
use yii\helpers\ArrayHelper;


/** @var yii\web\View $this */
/** @var app\models\Empresa $model */
/** @var yii\widgets\ActiveForm $form */
?>

<div class="empresa-form">

    <?php $form = ActiveForm::begin(); ?>


    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-7">
                        <div class="card-body">
                            <h5 class="card-title text-primary">Acércate más a tus clientes 💻</h5>
                            <p class="mb-4">
                                Configura tu landing page de una manera fácil y rápida.
                            </p>

                            <a href="javascript:;" class="btn btn-sm btn-outline-primary" onclick="visitarWeb()">Visistar web</a>
                        </div>
                    </div>
                    <div class="col-sm-5 text-center text-sm-left">
                        <div class="card-body pb-0 px-0 px-md-4">
                            <img
                                src="../assets/img/illustrations/man-with-laptop-light.png"
                                height="140"
                                alt="View Badge User"
                                data-app-dark-img="illustrations/man-with-laptop-dark.png"
                                data-app-light-img="illustrations/man-with-laptop-light.png" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>



    <div class="row">

        <div class="col-md-6">

            <div class="card mb-4">
                <h5 class="card-header">Datos generales</h5>

                <div class="card-body">
                    <div>


                        <?= $form->field($model, 'nombre')->textInput(['maxlength' => true]) ?>



                        <br>

                        <?= $form->field($model, 'horario_atencion')->textInput(['maxlength' => true]) ?>

                        <?= $form->field($model, 'telefonos')->textInput(['maxlength' => true]) ?>

                        <?= $form->field($model, 'whatsapp')->textInput(['maxlength' => true]) ?>

                        <?= $form->field($model, 'facebook')->textInput(['maxlength' => true]) ?>

                        <?= $form->field($model, 'direccion')->textInput(['maxlength' => true]) ?>

                    </div>
                </div>
            </div>


            <!--div class="card mb-4">
                <h5 class="card-header">Servicios</h5>

                <div class="card-body">
                    <div>


                        <?= $form->field($model, 'venta')->textarea(['rows' => 2]) ?>
                        <?= $form->field($model, 'mantenimiento')->textarea(['rows' => 2]) ?>
                        <?= $form->field($model, 'reparacion')->textarea(['rows' => 2]) ?>



                    </div>
                </div>
            </--div-->



            <div class="card mb-4">
                <h5 class="card-header">Ubicación</h5>
                <div class="card-body">
                    <div>


                        <?= $form->field($model, 'mapa')->widget(FileInput::classname(), [
                            'options' => ['accept' => 'image/*', 'id' => 'mapa'],
                            'pluginOptions' => [
                                'initialPreview' => $model->mapa ? [
                                    Yii::$app->urlManager->baseUrl . '/uploads/images/' . $model->mapa,
                                ] : '',
                                'initialPreviewAsData' => true,
                                'overwriteInitial' => true,
                                'showUpload' => false,
                                'showRemove' => false,
                                'initialCaption' => $model->mapa ? $model->mapa : ''
                            ],
                        ]); ?>

                        <br>

                        <?= $form->field($model, 'googlemaps')->textarea(['rows' => 2]) ?>

                    </div>
                </div>
            </div>




        </div>





        <div class="col-md-6">

            <div class="row">
                <div class="card mb-4">
                    <h5 class="card-header">Configuración landing</h5>
                    <div class="card-body">
                        <div>

                            <?= $form->field($model, 'descripcion_banner')->textarea(['rows' => 6]) ?>

                            <br>


                            <?= $form->field($model, 'imagen_banner')->widget(FileInput::classname(), [
                                'options' => ['accept' => 'image/*', 'id' => 'imagen_banner'],
                                'pluginOptions' => [
                                    'initialPreview' => $model->imagen_banner ? [
                                        Yii::$app->urlManager->baseUrl . '/uploads/images/' . $model->imagen_banner,
                                    ] : '',
                                    'initialPreviewAsData' => true,
                                    'overwriteInitial' => true,
                                    'showUpload' => false,
                                    'showRemove' => false,
                                    'initialCaption' => $model->imagen_banner ? $model->imagen_banner : ''
                                ],
                            ]); ?>




                            <br>

                            <?= $form->field($model, 'logotipo')->widget(FileInput::classname(), [
                                'options' => ['accept' => 'image/*', 'id' => 'logotipo'],
                                'pluginOptions' => [
                                    'initialPreview' => $model->logotipo ? [
                                        Yii::$app->urlManager->baseUrl . '/uploads/images/' . $model->logotipo,
                                    ] : '',
                                    'initialPreviewAsData' => true,
                                    'overwriteInitial' => true,
                                    'showUpload' => false,
                                    'showRemove' => false,
                                    'initialCaption' => $model->logotipo ? $model->logotipo : ''
                                ],
                            ]); ?>

                            <br>







                        </div>
                    </div>
                </div>

            </div>








        </div>



    </div>









    <div class="form-group">
        <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>


<script>
    function visitarWeb() {
        window.open('web/index.php', '_blank');
    }
</script>