<?php

use app\models\Empresa;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var app\models\EmpresaSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Empresas';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="empresa-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Create Empresa', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); 
    ?>


    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">


                            <?= GridView::widget([
                                'dataProvider' => $dataProvider,
                                'filterModel' => $searchModel,
                                'columns' => [
                                    ['class' => 'yii\grid\SerialColumn'],

                                    'codigo',
                                    'nombre',
                                    'descripcion_banner:ntext',
                                    'imagen_banner',
                                    'nosotros:ntext',
                                    //'horario_atencion',
                                    //'telefonos',
                                    //'logotipo',
                                    //'marcas',
                                    //'whatsapp',
                                    //'facebook',
                                    //'direccion',
                                    //'mapa',
                                    //'googlemaps:ntext',
                                    [
                                        'class' => ActionColumn::className(),
                                        'urlCreator' => function ($action, Empresa $model, $key, $index, $column) {
                                            return Url::toRoute([$action, 'codigo' => $model->codigo]);
                                        }
                                    ],
                                ],
                            ]); ?>




                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>




</div>