<?php

use app\models\Gastos;
use app\models\Parametros;
use app\models\Tipogastos;
use app\models\User;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;
use Yii;

/** @var yii\web\View $this */
/** @var app\models\GastosSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Gastos';
$this->params['breadcrumbs'][] = $this->title;

$tipGasto = Tipogastos::find()->where(['tip_estado' => Parametros::ACTIVO])->all();
$arrayTipoGastos = ArrayHelper::map($tipGasto, 'tip_gasto_id', 'tip_gasto_nombre');


$userModel = Yii::$app->user->identity;

?>
<div class="gastos-index">


    <div style="display: flex; justify-content: space-between;">
        <h1><?= Html::encode($this->title) ?></h1>
        <span style="font-size: 20px;  color: #515050; display: inline-block; padding-right: 10px; padding-left: 10px; text-align: center;">$<?= number_format($total, 2)  ?> <br> <span style="font-size: 14px;">Total gastos</span> </span>
    </div>

    <p style="text-align: right;">
        <?= Html::a('Agregar Gasto', ['create'], ['class' => 'btn btn-success']) ?>
    </p>


    <?php // echo $this->render('_search', ['model' => $searchModel]); 
    ?>



    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">


                            <?= GridView::widget([
                                'dataProvider' => $dataProvider,
                                'filterModel' => $searchModel,
                                'columns' => [
                                    ['class' => 'yii\grid\SerialColumn'],

                                    //   'gas_id',
                                    'gas_fecha',
                                    'gas_descripcion',
                                    [
                                        'attribute' => 'gas_tipo',
                                        'value' => function ($model) {
                                            $tipo = Tipogastos::find()->where(['tip_gasto_id' => $model->gas_tipo])->one();
                                            return $tipo->tip_gasto_nombre;
                                        },
                                        'filter' => $arrayTipoGastos
                                    ],

                                    [
                                        'attribute' => 'gas_valor',
                                        'value' => function ($model) {
                                            $valor = number_format($model->gas_valor, 2);
                                            return "$$valor";
                                        },

                                    ],

                                    [
                                        'attribute' => 'created_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->created_by])->one();
                                            return $user->nombre;
                                        },

                                    ],
                                    //'created_at',
                                    //'updated_at',
                                    //'created_by',
                                    //'updated_by',
                                    [
                                        'class' => ActionColumn::className(),
                                        'urlCreator' => function ($action, Gastos $model, $key, $index, $column) {
                                            return Url::toRoute([$action, 'gas_id' => $model->gas_id]);
                                        },
                                        'visibleButtons' => [
                                            // Configurar la visibilidad de los botones según la variable $userModel y la fecha actual
                                            'update' => function ($model, $key, $index) use ($userModel) {
                                                $hoy = date('Y-m-d'); // Obtener la fecha actual
                                                return ($model->created_by == $userModel->id && $model->gas_fecha == $hoy) ? true : false;
                                            },
                                            'view' => function ($model, $key, $index) use ($userModel) {
                                                return  false;
                                            },
                                            'delete' => function ($model, $key, $index) use ($userModel) {
                                                $hoy = date('Y-m-d'); // Obtener la fecha actual
                                                return ($model->created_by == $userModel->id && $model->gas_fecha == $hoy) ? true : false;
                                            },
                                        ],

                                        'buttons' => [
                                            'delete' => function ($url, $model, $key) {
                                                return Html::a('<i class="fas fa-trash"></i>', $url, [
                                                    'title' => Yii::t('app', 'Eliminar'), // Título del botón (opcional)
                                                    'data-confirm' => '¿Estás seguro de que deseas eliminar este elemento?', // Mensaje en español
                                                    'data-method' => 'post', // Método para eliminar
                                                    'data-pjax' => '0', // Si usas Pjax, esto previene la actualización por Ajax
                                                ]);
                                            },
                                        ],
                                    ],
                                ],
                            ]); ?>


                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>







</div>