<?php

/** @var yii\web\View $this */
/** @var string $content */

use app\assets\AppAsset;
use app\widgets\Alert;
use yii\bootstrap5\Breadcrumbs;
use yii\bootstrap5\Html;
use yii\bootstrap5\Nav;
use yii\bootstrap5\NavBar;

use app\models\Empresa;
use app\models\Parametros;

$empresa = Empresa::find()->where(['codigo' => Parametros::empresa])->one();


AppAsset::register($this);

$this->registerCsrfMetaTags();
$this->registerMetaTag(['charset' => Yii::$app->charset], 'charset');
$this->registerMetaTag(['name' => 'viewport', 'content' => 'width=device-width, initial-scale=1, shrink-to-fit=no']);
$this->registerMetaTag(['name' => 'description', 'content' => $this->params['meta_description'] ?? '']);
$this->registerMetaTag(['name' => 'keywords', 'content' => $this->params['meta_keywords'] ?? '']);
$this->registerLinkTag(['rel' => 'icon', 'type' => 'image/x-icon', 'href' => Yii::getAlias('@web/favicon.ico')]);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>" class="h-100">

<head>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Dancing+Script&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />

    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" integrity="sha512-DTOQO9RWCH3ppGqcWaEA1BIZOC6xxalwEsw9c2QQeAIftl+Vegovlnee1c9QX4TctnWMn13TZye+giMm8e2LwA==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <!--script src="//code.jivosite.com/widget/18yHaLXE5j" async></!--script-->



    <style>
        p {
            font-family: 'Montserrat', sans-serif;
            font-weight: 400;
        }

        .btn-primary {
            background-color: #1458A4;
        }

        .carrera-img:hover {
            filter: opacity(.6);
        }

        .heartbeat-button {
            font-size: 18px;
            padding: 10px 20px;
            border: none;
            background-color: #007bff;
            color: #fff;
            border-radius: 5px;
            cursor: pointer;
            animation: heartbeat 2s infinite ease-in-out;
            background-color: #1458A4;
        }

        .nav-link {
            color: white;
        }

        .nav-link:hover {
            font-weight: 500;
            color: white;
        }

        .nav-link2 {
            color: grey;
            text-decoration: none;
            font-size: 13px;
        }

        .logos img {
            width: 85%;
            display: block;
            margin: auto;
        }

        .accordion-button:not(.collapsed) {
            color: white;
            background-color: #1458A4;
        }

        @keyframes heartbeat {

            0%,
            100% {
                transform: scale(1);
            }

            50% {
                transform: scale(1.1);
            }
        }

        .carouselExampleControls {
            padding: 5%;
        }

        .card {
            border: none;
        }

        .btn-primary {}

        .floating-button {
            position: fixed;
            /* Posicionamiento fijo en la pantalla */
            bottom: 50px;
            /* 10px desde la parte inferior de la pantalla */
            right: 10px;
            /* 10px desde la parte derecha de la pantalla */
            z-index: 999;
            /* Asegura que el botón esté por encima de otros elementos */
        }

        .floating-button button {
            background-color: #166da7;
            color: white;
            border: none;
            border-radius: 9px;
            cursor: pointer;
            opacity: 0.9;
            size: 11px;
        }

        .floating-button button:hover {
            background-color: #166da7;
            opacity: 1;
        }
    </style>
</head>

<body class="d-flex flex-column h-100">




    <?php $this->beginBody() ?>

    <!-- MENU PRINCIPAL -->

    <nav class="navbar navbar-expand-lg " style="background-color: #2e465f;">
        <div class="container">

            <a class="navbar-brand" style="color:white" aria-current="page" href="<?= \yii\helpers\Url::to(['site/index']) ?>#inicio"><?= $empresa->nombre ?></a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                    <li class="nav-item">
                        <a class="nav-link" aria-current="page" href="<?= \yii\helpers\Url::to(['site/index']) ?>#inicio">Inicio</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link" aria-current="page" href="<?= \yii\helpers\Url::to(['productos/ver-catalogo']) ?>">Ver catálogo</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#contactanos">Contáctanos</a>
                    </li>


                </ul>


                <div class="d-flex" style="padding: 4px; ">
                    <a class="btn btn-outline-default btn-sm" style="color: white; border-color: white;" aria-current="page" href="<?= \yii\helpers\Url::to(['site/login']) ?>#inicio">Acceder</a>

                </div>

            </div>
        </div>
    </nav>




    <div>
        <div class="container-fluid">
            <?= $content ?>

        </div>
    </div>


    <footer id="footer" class="mt-auto" style="background-color: #2e465f; padding-top: 15px; padding-bottom: 15px;" >
        <div class="container" style="display: flex; align-items: center;">
            <div class="col-md-6 text-center text-white" style="flex: 1;">
                &copy; <?= $empresa->nombre ?> <?= date('Y') ?>
            </div>

        </div>
        </div>
    </footer>

    <script>
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
        var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl)
        })
    </script>

    <?php $this->endBody() ?>
</body>

</html>
<?php $this->endPage() ?>