<?php

use app\models\Parametros;
use app\models\User;
use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var app\models\Marcas $model */

$this->title = $model->mar_id;
$this->params['breadcrumbs'][] = ['label' => 'Marcas', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="marcas-view">



    <p>
        <?= Html::a('Actualizar', ['update', 'mar_id' => $model->mar_id], ['class' => 'btn btn-success btn-sm']) ?>
    </p>


    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">

                            <?= DetailView::widget([
                                'model' => $model,
                                'attributes' => [
                                    //  'mar_id',
                                    'mar_nombre',
                                    [
                                        'attribute' => 'mar_estado',
                                        'value' => function ($model) {
                                            return $model->mar_estado === Parametros::ACTIVO ? 'Activo' : 'Inactivo';
                                        },

                                    ],
                                    'created_at',
                                    'updated_at',
                                    [
                                        'attribute' => 'created_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->created_by])->one();
                                            return $user->nombre;
                                        },

                                    ],
                                    [
                                        'attribute' => 'updated_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->updated_by])->one();
                                            return $user->nombre;
                                        },

                                    ],
                                ],
                            ]) ?>


                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>






</div>