<?php

use app\models\Metodospago;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var app\models\MetodospagoSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Metodospagos';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="metodospago-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Agregar Métodos Pago', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); 
    ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            // 'met_pago_id',
            'met_pago_nombre',
            'met_pago_estado',
            //    'created_at',
            //  'updated_at',
            //'created_by',
            //'updated_by',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, Metodospago $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'met_pago_id' => $model->met_pago_id]);
                }
            ],
        ],
    ]); ?>


</div>