<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "modulobase".
 *
 * @property string $codigo
 * @property string $texto
 * @property string $contenido
 * @property string $estado
 * @property string $tipo
 * @property string $imagen
 */
class Modulobase extends \yii\db\ActiveRecord
{
    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'modulobase';
    }

    /**
     * {@inheritdoc}
     */
    public function rules()
    {
        return [
            [['codigo', 'texto', 'contenido', 'estado', 'tipo', 'imagen'], 'required'],  
            [['contenido'], 'string'],
            [['codigo'], 'string', 'max' => 10],
            [['texto', 'imagen'], 'string', 'max' => 50],
            [['estado'], 'string', 'max' => 1],
            [['tipo'], 'string', 'max' => 20],
            [['codigo'], 'unique'],
        ];
    }

    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'codigo' => 'Codigo',
            'texto' => 'Texto',
            'contenido' => 'Contenido',
            'estado' => 'Estado',
            'tipo' => 'Tipo',
            'imagen' => 'Imagen',
        ];
    }
}
