<?php

use app\models\Catalogo;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\file\FileInput;
use dosamigos\ckeditor\CKEditor;
use yii\helpers\ArrayHelper;


//::   Se obtiene el catalogo desde base
$catalogo = Catalogo::find()->where(['estado'=>'A'])->all();
$arrayCatalogo= ArrayHelper::map($catalogo, 'codigo', 'producto');


/** @var yii\web\View $this */
/** @var app\models\Modulobase $model */
/** @var yii\widgets\ActiveForm $form */
?>



<div class="modulobase-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
                                <div class="card">
                                  <div class="d-flex align-items-end row">
                                    <div class="col-sm-7">
                                      <div class="card-body">
                                        <h5 class="card-title text-primary">Congratulations John! 🎉</h5>
                                        <p class="mb-4">
                                          You have done <span class="fw-bold">72%</span> more sales today. Check your new badge in
                                          your profile.
                                        </p>

                                        <a href="javascript:;" class="btn btn-sm btn-outline-primary">View Badges</a>
                                      </div>
                                    </div>
                                    <div class="col-sm-5 text-center text-sm-left">
                                      <div class="card-body pb-0 px-0 px-md-4">
                                        <img
                                          src="../assets/img/illustrations/man-with-laptop-light.png"
                                          height="140"
                                          alt="View Badge User"
                                          data-app-dark-img="illustrations/man-with-laptop-dark.png"
                                          data-app-light-img="illustrations/man-with-laptop-light.png"
                                        />
                                      </div>
                                    </div>
                                  </div>
                            </div>
                </div>
    </div>




    <div class="row">


                <div class="col-md-6">

                      <div class="card mb-4">
                        <h5 class="card-header">Campos generales</h5>
                        <div class="card-body">
                          <div>

                            <?= $form->field($model, 'codigo')->textInput(['maxlength' => true, 'readonly' => !$model->isNewRecord]) ?>

                         

                            <div id="defaultFormControlHelp" class="form-text">
                              We'll never share your details with anyone else.
                            </div>


                          </div>
                        </div>
                      </div>
                  
                </div>


                <div class="col-md-6">

                      <div class="card mb-4">
                        <h5 class="card-header">Campos generales</h5>
                        <div class="card-body">
                          <div>

                            
    <?= $form->field($model, 'texto')->textInput(['maxlength' => true]) ?>

                            <div id="defaultFormControlHelp" class="form-text">
                              We'll never share your details with anyone else.
                            </div>
                          </div>
                        </div>
                      </div>
                </div>
    </div>

    

    <div class="row">


                <div class="col-md-12">

                      <div class="card mb-4">
                        <h5 class="card-header">Campos generales</h5>
                        <div class="card-body">
                          <div>

                          <?= $form->field($model, 'contenido')->widget(CKEditor::class, [
                              'options' => ['rows' => 5],
                              'preset' => 'full', 
                          ])->label(false); ?>


                            <div id="defaultFormControlHelp" class="form-text">
                              We'll never share your details with anyone else.
                            </div>

                          </div>
                        </div>
                      </div>
                  
                </div>


    </div>






    


       
    <div class="col-md-3">
            <?= $form->field($model, 'estado')->dropDownList(['A'=>'Activo', 'I'=>'Inactivo']) ?>
    </div>


   <!-- catalogo  DESDE BASE DE DATOS    --> 
    <div class="col-md-3">
            <?= $form->field($model, 'tipo')->dropDownList($arrayCatalogo, ['prompt' => 'Selecciona una opción']) ?>
    </div>


    

    <?= $form->field($model, 'imagen')->widget(FileInput::classname(), [
                'options' => ['accept' => 'image/*', 'id' => 'imagen'],
                'pluginOptions' => [
                    'initialPreview' => $model->imagen? [
                        Yii::$app->urlManager->baseUrl . '/uploads/images/'.$model->imagen,
                    ]:'',
                    'initialPreviewAsData' => true,
                    'overwriteInitial' => true,
                    'showUpload' => false, 
                    'showRemove' => false,
                    'initialCaption' => $model->imagen? $model->imagen:''
                ],
                ]);?>

                
    <div class="form-group">
        <?= Html::submitButton(
            $model->isNewRecord ? 'Guardar' : 'Modificar',
            ['class' => 'btn btn-success']
        ) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
