<?php

use app\models\Modulobase;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var app\models\ModulobaseSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Modulobases';
$this->params['breadcrumbs'][] = $this->title;
?>




<div class="modulobase-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Crear módulo', ['create'], ['class' => 'btn btn-success btn-sm']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>



    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
                                <div class="card">
                                  <div class="d-flex align-items-end row">
                                    <div class="col-sm-12">
                                      <div class="card-body">

                                      <?= GridView::widget([
                                        'dataProvider' => $dataProvider,
                                        'filterModel' => $searchModel,
                                        'columns' => [
                                            ['class' => 'yii\grid\SerialColumn'],

                                            'codigo',
                                            'texto',
                                            'estado',
                                            'tipo',
                                            //'imagen',
                                            [
                                                'class' => ActionColumn::className(),
                                                'urlCreator' => function ($action, Modulobase $model, $key, $index, $column) {
                                                    return Url::toRoute([$action, 'codigo' => $model->codigo]);
                                                }
                                            ],
                                        ],
                                    ]); ?>
                                        

                                       
                                      </div>
                                    </div>
                                    
                                  </div>
                            </div>
                </div>
    </div>


</div>


