<?php

use app\models\Categorias;
use app\models\Colores;
use app\models\Marcas;
use app\models\Parametros;
use app\models\Proveedores;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\file\FileInput;
use dosamigos\ckeditor\CKEditor;


$proveedores = Proveedores::find()->where(['prov_estado' => Parametros::ACTIVO])->all();
$arrayproveedores = ArrayHelper::map($proveedores, 'prov_id', 'prov_nombre');


$categorias = Categorias::find()->where(['cat_estado' => Parametros::ACTIVO])->all();
$arraycategorias = ArrayHelper::map($categorias, 'cat_id', 'cat_nombre');


$colores = Colores::find()->where(['col_estado' => Parametros::ACTIVO])->all();
$arrayColores = ArrayHelper::map($colores, 'col_id', 'col_nombre');


$marcas = Marcas::find()->where(['mar_estado' => Parametros::ACTIVO])->all();
$arrayMarcas = ArrayHelper::map($marcas, 'mar_id', 'mar_nombre');

$detalleStock = [];

if (!empty($model->pro_aumentar_stock)) {
    $detalleStock = explode('|', $model->pro_aumentar_stock) ?? '';
}


/** @var yii\web\View $this */
/** @var app\models\Productos $model */
/** @var yii\widgets\ActiveForm $form */
?>

<div class="productos-form">

    <?php $form = ActiveForm::begin(); ?>



    <div class="row">


        <div class="col-md-6">

            <div class="card mb-4">
                <h5 class="card-header">Datos generales</h5>
                <div class="card-body">
                    <div>

                        <?= $form->field($model, 'pro_estado')->dropDownList([Parametros::ACTIVO => 'Activo', Parametros::INACTIVO => 'Inactivo']) ?>

                        <?= $form->field($model, 'pro_codigo')->textInput(['maxlength' => true,  'readonly' => !$model->isNewRecord]) ?>


                        <?= $form->field($model, 'pro_nombre')->textInput(['maxlength' => true]) ?>




                        <div class="row">
                            <div class="<?= $model->isNewRecord ? 'col-md-12' : 'col-md-6' ?>">
                                <?= $form->field($model, 'pro_stock')->textInput(['readonly' => !$model->isNewRecord]) ?>
                            </div>


                            <?php
                            if (!$model->isNewRecord) { ?>
                                <div class="col-md-3">
                                    <br>
                                    <a class="btn btn-success" id="openModalPlus" <?= !$model->isNewRecord ? '' : 'disabled' ?>>+ Agregar</a>
                                </div>

                                <div class="col-md-3">
                                    <br>
                                    <a class="btn btn-danger" id="openModalDism" <?= !$model->isNewRecord ? '' : 'disabled' ?>>- Disminuir</a>
                                </div>

                            <?php    }
                            ?>



                        </div>



                        <?= $form->field($model, 'prov_id')->dropDownList($arrayproveedores, ['prompt' => 'Seleccione una proveedor']) ?>

                        <?= $form->field($model, 'cat_id')->dropDownList($arraycategorias, ['prompt' => 'Seleccione una categoria']) ?>


                        <?= $form->field($model, 'pro_marca')->dropDownList($arrayMarcas, ['prompt' => 'Seleccione una marca']) ?>

                 


                        <?= $form->field($model, 'pro_talla')->textInput() ?>

                        <?= $form->field($model, 'pro_color')->dropDownList($arrayColores, ['prompt' => 'Seleccione un color']) ?>

                        <br>


                        <?= $form->field($model, 'pro_foto')->widget(FileInput::classname(), [
                            'options' => ['accept' => 'image/*', 'id' => 'pro_foto'],
                            'pluginOptions' => [
                                'initialPreview' => $model->pro_foto ? [
                                    Yii::$app->urlManager->baseUrl . '/uploads/images/' . $model->pro_foto,
                                ] : '',
                                'initialPreviewAsData' => true,
                                'overwriteInitial' => true,
                                'showUpload' => false,
                                'showRemove' => false,
                                'initialCaption' => $model->pro_foto ? $model->pro_foto : ''
                            ],
                        ]); ?>



                        <br>

                        <label>Detalle</label>
                        <?= $form->field($model, 'pro_descripcion')->widget(CKEditor::class, [
                            'options' => ['rows' => 5],
                            'preset' => 'basic',
                        ])->label(false); ?>




                    </div>
                </div>
            </div>

        </div>


        <div class="col-md-6">

            <div class="card mb-4">
                <h5 class="card-header">Configuración de valores</h5>
                <div class="card-body">
                    <div>

                        <?= $form->field($model, 'pro_costo')->textInput() ?>

                        <?= $form->field($model, 'pro_pvp')->textInput() ?>

                        <?= $form->field($model, 'pro_pvp_tarjeta')->textInput() ?>

                        <?= $form->field($model, 'pro_dscto')->checkbox() ?>

                        <?= $form->field($model, 'pro_cant_min_desct')->textInput() ?>

                        <?= $form->field($model, 'pro_porc_dscto')->textInput() ?>



                    </div>
                </div>
            </div>


            <div class="card mb-4">
                <h5 class="card-header">Historial de aumento/disminución manual de Stock</h5>
                <div class="card-body">
                    <div>

                        <?php
                        foreach ($detalleStock as $detalle) {
                            if ($detalle !== '') {
                        ?>

                                <span style="color: grey; font-size: 12px;"><?= $detalle ?></span>

                                <hr>

                        <?php       }
                        }
                        ?>




                    </div>
                </div>
            </div>

        </div>

    </div>




    <div class="form-group">
        <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>


<div class="modal fade" id="myModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header" style="background-color: #696cff;">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #fff;">Agregar productos al stock </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-4">
                        <label for="">Cantidad</label>
                        <input id="cantidadProd" class="form-control" type="number" min="1">
                    </div>
                    <div class="col-md-8">
                        <label for="">Num. Factura</label>
                        <input id="numFactura" class="form-control" type="text">
                    </div>
                </div>
                <br>

                <div class="row">
                    <div class="col-md-12">
                        <label for="">Detalle</label>
                        <input id="detalleProd" class="form-control" type="text">
                    </div>
                </div>

                <br>

            </div>
            <div class="modal-footer">
                <a type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</a>
                <a onclick="agregarStock()" type="button" class="btn btn-success">Agregar a Stock</a>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="myModal2" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header" style="background-color: #696cff;">
                <h5 class="modal-title" id="exampleModalLabel" style="color: #fff;">Quitar productos al stock </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <label for="">Cantidad</label>
                        <input id="cantidadProd2" class="form-control" type="number" min="1">
                    </div>

                </div>

                <br>

                <div class="row">
                    <div class="col-md-12">
                        <label for="">Detalle</label>
                        <input id="detalleProd2" class="form-control" type="text">
                    </div>
                </div>

                <br>

            </div>
            <div class="modal-footer">
                <a type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</a>
                <a onclick="disminuirStock()" type="button" class="btn btn-danger">Disminuir Stock</a>
            </div>
        </div>
    </div>
</div>


<script>
    window.onload = function() {



        $('#productos-pro_codigo').focus();

        $('#productos-pro_codigo').on('keyup', function(event) {
            let inputValue = $(this).val().trim();

            // Verificamos si la tecla presionada es 'Enter'
            if (event.key === 'Enter') {
                // Solo si hay un valor en el input
                if (inputValue !== '') {
                    $('#productos-pro_nombre').focus(); // Colocar el foco
                }
                // Aquí podrías llamar a tu función consultaProducto() si es necesario
            } else {
                event.preventDefault(); // Evitamos que se procese la tecla si no es 'Enter'
            }
        });


    };




    $(document).ready(function() {

        $('#openModalPlus').click(function() {
            $('#myModal').modal('show'); // Abre el modal
        });


        $('#openModalDism').click(function() {
            $('#myModal2').modal('show'); // Abre el modal
        });


    });


    function agregarStock() {


        let numFactura = $('#numFactura').val()
        let cantidad = $('#cantidadProd').val()
        let detalle = $('#detalleProd').val()
        let id = <?= $model->pro_id ?>


        if (cantidad == '' || cantidad < 1) {
            Swal.fire({
                title: "Oops...",
                text: 'Por favor, ingrese la cantidad',
            });
            return false
        }

        $.get(`index.php?r=productos/agregar-stock&id=${id}&numFactura=${numFactura}&detalle=${detalle}&cantidad=${cantidad}`)
            .done(function(data) {
                data = JSON.parse(data)


                console.log(data);

                if (data.transaccion) {

                    $('#numFactura').val('')
                    $('#cantidadProd').val('')
                    $('#detalleProd').val('')


                    $('#myModal').modal('hide'); // Abre el modal

                    Swal.fire({
                        text: 'Se ha actualizado el Stock de forma correcta',
                        icon: 'success'
                    }).then((result) => {
                        if (result.isConfirmed || result.isDismissed) {
                            // Recargar la página
                            location.reload();
                        }
                    });


                } else {
                    Swal.fire({
                        title: "Oops...",
                        text: "Error al procesar tu solicitud",
                    });
                }
            })
            .fail(function(xhr, status, error) {
                // Manejar el error
                console.error('Error en la solicitud:', error);
            });
    }


    function disminuirStock() {

        let cantidad = $('#cantidadProd2').val()
        let detalle = $('#detalleProd2').val()
        let id = <?= $model->pro_id ?>


        if (cantidad == '' || cantidad < 1) {
            Swal.fire({
                title: "Oops...",
                text: 'Por favor, ingrese la cantidad',
            });
            return false
        }

        $.get(`index.php?r=productos/disminuir-stock&id=${id}&detalle=${detalle}&cantidad=${cantidad}`)
            .done(function(data) {
                data = JSON.parse(data)


                console.log(data);

                if (data.transaccion) {

                    $('#numFactura2').val('')

                    $('#detalleProd2').val('')


                    $('#myModal2').modal('hide'); // Abre el modal

                    Swal.fire({
                        text: 'Se ha actualizado el Stock de forma correcta',
                        icon: 'success'
                    }).then((result) => {
                        if (result.isConfirmed || result.isDismissed) {
                            // Recargar la página
                            location.reload();
                        }
                    });


                } else {
                    Swal.fire({
                        title: "Oops...",
                        text: data.error,
                    });
                }
            })
            .fail(function(xhr, status, error) {
                // Manejar el error
                console.error('Error en la solicitud:', error);
            });
    }
</script>