<?php

use app\models\Categorias;
use app\models\Parametros;
use app\models\Productos;
use PhpOffice\PhpSpreadsheet\Reader\Xml\Style\NumberFormat;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use yii\helpers\ArrayHelper;


/** @var yii\web\View $this */
/** @var app\models\ProductosSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Productos';
$this->params['breadcrumbs'][] = $this->title;

$categorias = Categorias::find()->where([])->all();
$arrayCategorias = ArrayHelper::map($categorias, 'cat_id', 'cat_nombre');

$userModel = Yii::$app->user->identity;
$esAdmin = false;
if (!empty($userModel->rol) && $userModel->rol === 'superAdmin') {
    $esAdmin = true;
}



?>
<div class="productos-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p style="text-align: right;">
        <?php
        if ($esAdmin) {
            echo Html::a('Crear producto', ['create'], ['class' => 'btn btn-success']);
        }
        ?>

    </p>



    <?php // echo $this->render('_search', ['model' => $searchModel]); 
    ?>



    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">

                            <?= GridView::widget([
                                'dataProvider' => $dataProvider,
                                'filterModel' => $searchModel,
                                'columns' => [
                                    ['class' => 'yii\grid\SerialColumn'],

                                    //  'pro_id',

                                    [
                                        'attribute' => 'pro_foto',
                                        'format' => 'raw',
                                        'value' => function ($model) {
                                            return '<img 
                                                style="border-radius: 10px; max-height: 180px; width: auto" 
                                                class="card-img-top img-fluid carrera-img" 
                                                src="' . Yii::$app->urlManager->baseUrl . '/uploads/images/' . $model->pro_foto . '" 
                                                alt="">';
                                        },

                                    ],
                                    'pro_nombre',
                                    'pro_codigo',
                                    //'pro_foto',



                                    //'pro_talla',

                                    [
                                        'attribute' => 'cat_id',
                                        'value' => function ($model) {
                                            $categoria = Categorias::find()->where(['cat_id' => $model->cat_id])->one();
                                            return $categoria->cat_nombre ?? '';
                                        },
                                        'filter' => $arrayCategorias
                                    ],
                                    //'pro_modelo',
                                    //'pro_color',
                                    //'pro_costo',
                                    'pro_stock',


                                    [
                                        'label' => 'Costo',
                                        'attribute' => 'pro_costo',
                                        'value' => function ($model) use ($esAdmin) { // Use the $esAdmin variable in the closure
                                            if ($esAdmin) {
                                                $valor = number_format($model->pro_costo, 2);
                                                return "$$valor";
                                            } else {
                                                return '****';
                                            }
                                        },
                                    ],

                                    [
                                        'label' => 'P.V.P.',
                                        'attribute' => 'pro_pvp',
                                        'value' => function ($model) {
                                            $valor = number_format($model->pro_pvp, 2);
                                            return "$$valor";
                                        },

                                    ],

                                    [
                                        'label' => 'P.V.P. Tarjeta',
                                        'attribute' => 'pro_pvp_tarjeta',
                                        'value' => function ($model) {
                                            $valor = number_format($model->pro_pvp_tarjeta, 2);
                                            return "$$valor";
                                        },

                                    ],


                                    //'pro_dscto',
                                    //'pro_descripcion:ntext',
                                    //'pro_marca',
                                    //'pro_estado',
                                    //'pro_cant_min_desct',
                                    //'pro_porc_dscto',

                                    //'created_at',
                                    //'updated_at',
                                    //'created_by',
                                    //'updated_by',

                                    [
                                        'attribute' => 'pro_estado',
                                        'value' => function ($model) {
                                            return $model->pro_estado === Parametros::ACTIVO ? 'Activo' : 'Inactivo';
                                        },
                                        'filter' => ['A' => 'Activo', 'I' => 'Inactivo'], // Opcional, para agregar el filtro en el GridView
                                    ],
                                    [
                                        'class' => ActionColumn::className(),
                                        'urlCreator' => function ($action, Productos $model, $key, $index, $column) {
                                            return Url::toRoute([$action, 'pro_id' => $model->pro_id]);
                                        },
                                        'visibleButtons' => [ // Configurar la visibilidad de los botones según la variable $admin
                                            'update' => function ($model, $key, $index) use ($esAdmin) {
                                                return $esAdmin; // Solo muestra el botón si $admin es true
                                            },
                                            'delete' => function ($model, $key, $index) use ($esAdmin) {
                                                return $esAdmin; // Solo muestra el botón si $admin es true
                                            },
                                        ],
                                        'buttons' => [
                                            'delete' => function ($url, $model, $key) {
                                                return Html::a('<i class="fas fa-trash"></i>', $url, [
                                                    'title' => Yii::t('app', 'Eliminar'), // Título del botón (opcional)
                                                    'data-confirm' => '¿Estás seguro de que deseas eliminar este elemento?', // Mensaje en español
                                                    'data-method' => 'post', // Método para eliminar
                                                    'data-pjax' => '0', // Si usas Pjax, esto previene la actualización por Ajax
                                                ]);
                                            },
                                        ],
                                    ],
                                ],
                            ]); ?>


                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>




</div>