<?php

use app\models\Parametros;
use yii\helpers\Html;
use yii\widgets\ActiveForm;

/** @var yii\web\View $this */
/** @var app\models\Proveedores $model */
/** @var yii\widgets\ActiveForm $form */
?>

<div class="proveedores-form">

    <?php $form = ActiveForm::begin(); ?>

    <div class="row">
        <div class="col-md-6">

            <div class="card mb-4">
                <h5 class="card-header">Datos generales</h5>
                <div class="card-body">
                    <div>

                        <?= $form->field($model, 'prov_tipo_identificacion')->dropDownList(
                            [Parametros::CEDULA => 'Cédula', Parametros::RUC => 'RUC'],
                            ['disabled' => !$model->isNewRecord]
                        ) ?>


                        <?= $form->field($model, 'prov_identificacion')->textInput(['maxlength' => true, 'readonly' => !$model->isNewRecord]) ?>

                        <?= $form->field($model, 'prov_nombre')->textInput(['maxlength' => true]) ?>

                        <?= $form->field($model, 'prov_direccion')->textInput(['maxlength' => true]) ?>

                        <?= $form->field($model, 'prov_correo')->textInput(['maxlength' => true]) ?>

                        <?= $form->field($model, 'prov_telefono')->textInput(['maxlength' => true]) ?>


                        <?= $form->field($model, 'prov_estado')->dropDownList([Parametros::ACTIVO => 'Activo', Parametros::INACTIVO => 'Inactivo']) ?>






                    </div>
                </div>
            </div>

        </div>
    </div>



    <div class="form-group">
        <?= Html::submitButton('Guardar', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>



<script>
    window.onload = function() {
        $('#proveedores-prov_identificacion').focus();
    }
</script>