<?php

use app\models\Parametros;
use app\models\Proveedores;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;
use Yii;

/** @var yii\web\View $this */
/** @var app\models\ProveedoresSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Proveedores';
$this->params['breadcrumbs'][] = $this->title;

$userModel = Yii::$app->user->identity;
$esAdmin = false;
if (!empty($userModel->rol) && $userModel->rol === 'superAdmin') {
    $esAdmin = true;
}


?>
<div class="proveedores-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Crear Proveedor', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); 
    ?>


    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">


                            <?= GridView::widget([
                                'dataProvider' => $dataProvider,
                                'filterModel' => $searchModel,
                                'columns' => [
                                    ['class' => 'yii\grid\SerialColumn'],

                                    //     'prov_id',
                                    'prov_identificacion',
                                    'prov_nombre',
                                    //'prov_direccion',
                                    'prov_correo',
                                    'prov_telefono',
                                    [
                                        'attribute' => 'prov_estado',
                                        'value' => function ($model) {
                                            return $model->prov_estado === Parametros::ACTIVO ? 'Activo' : 'Inactivo';
                                        },
                                        'filter' => ['A' => 'Activo', 'I' => 'Inactivo'], // Opcional, para agregar el filtro en el GridView
                                    ],
                                    //'created',
                                    //'created_at',
                                    //'updated_at',
                                    //'created_by',
                                    //'updated_by',
                                    [
                                        'class' => ActionColumn::className(),
                                        'urlCreator' => function ($action, Proveedores $model, $key, $index, $column) {
                                            return Url::toRoute([$action, 'prov_id' => $model->prov_id]);
                                        },
                                        'buttons' => [
                                            'delete' => function ($url, $model, $key) {
                                                return Html::a('<i class="fas fa-trash"></i>', $url, [
                                                    'title' => Yii::t('app', 'Eliminar'), // Título del botón (opcional)
                                                    'data-confirm' => '¿Estás seguro de que deseas eliminar este elemento?', // Mensaje en español
                                                    'data-method' => 'post', // Método para eliminar
                                                    'data-pjax' => '0', // Si usas Pjax, esto previene la actualización por Ajax
                                                ]);
                                            },
                                        ],
                                    ],
                                ],
                            ]); ?>


                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>






</div>