<?php

use app\models\Parametros;
use app\models\User;
use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var app\models\Proveedores $model */

$this->title = $model->prov_id;
$this->params['breadcrumbs'][] = ['label' => 'Proveedores', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="proveedores-view">



    <p>
        <?= Html::a('Actualizar', ['update', 'prov_id' => $model->prov_id], ['class' => 'btn btn-success btn-sm']) ?>

    </p>



    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">

                            <?= DetailView::widget([
                                'model' => $model,
                                'attributes' => [
                                    //   'prov_id',
                                    'prov_identificacion',
                                    'prov_nombre',
                                    'prov_direccion',
                                    'prov_correo',
                                    'prov_telefono',

                                    [
                                        'attribute' => 'prov_estado',
                                        'value' => function ($model) {
                                            return $model->prov_estado === Parametros::ACTIVO ? 'Activo' : 'Inactivo';
                                        },

                                    ],
                                    // 'prov_estado',
                                    'created_at',
                                    'updated_at',



                                    [
                                        'attribute' => 'created_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->created_by])->one();
                                            return $user->nombre;
                                        },

                                    ],
                                    [
                                        'attribute' => 'updated_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->updated_by])->one();
                                            return $user->nombre;
                                        },

                                    ]
                                ],
                            ]) ?>



                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>



</div>