<?php

use app\models\Metodospago;
use app\models\Parametros;
use app\models\User;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;



$metodosPagos = Metodospago::find()->where(['met_pago_estado' => Parametros::ACTIVO])->all();
$arrayproveedores = ArrayHelper::map($metodosPagos, 'met_pago_id', 'met_pago_nombre');


$usuarios = User::find()->where(['estado' => Parametros::ACTIVO])->all();



/** @var yii\web\View $this */
/** @var app\models\Facturas $model */
/** @var yii\widgets\ActiveForm $form */
?>


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>




<div class="facturas-form">





    <div class="row">
        <div class="col-md-12">

            <div class="card mb-4">

                <div class="card-body">
                    <div>

                        <div class="row">

                            <div class="col-md-4">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-4 col-form-label">Identificación</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" id="cliIdentificacion" onkeyup="consultaIdentificacion(this)" maxlength="13" style="background-color: #e3eff3;">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-5">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Nombre</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" id="cliNombre">
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-3">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Email</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" id="cliEmail">
                                    </div>
                                </div>
                            </div>

                        </div>

                        <div class="row">

                            <div class="col-md-6">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-2 col-form-label">Dirección</label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="cliDireccion">
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-3">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-4 col-form-label">Teléfono</label>
                                    <div class="col-sm-8">
                                        <input type="text" class="form-control" id="cliFono" minlength="7" maxlength="15">
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-3">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Celular</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" id="cliCelular" minlength="10" maxlength="10">
                                    </div>
                                </div>
                            </div>

                        </div>



                        <hr>









                    </div>
                </div>
            </div>

        </div>
    </div>



    <div class="row">
        <div class="col-md-12">

            <div class="card mb-4">

                <div class="card-body">
                    <div>

                        <div class="row">

                            <div class="col-md-3">
                                <div class="mb-3 d-flex align-items-center">
                                    <label for="identificacionInput" class=" col-sm-4 form-label me-2">Código</label>
                                    <input type="text" class="form-control" id="codigoProducto">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-3 col-form-label">Producto</label>
                                    <div class="col-sm-9">
                                        <input type="text" class="form-control" id="nomProducto">
                                    </div>
                                </div>
                            </div>


                            <div class="col-md-2">
                                <div class="mb-3 row">
                                    <label for="inputPassword" class="col-sm-4 col-form-label">PVP.</label>
                                    <div class="col-sm-8">
                                        <input type="text" min=1 class="form-control" id="pvpProducto" disabled>
                                    </div>
                                </div>
                            </div>


                            <?php

                            if ($model->isNewRecord) { ?>
                                <div class="col-md-2">
                                    <a class="btn btn-success" onclick="registrar()">Confirmar separado</a>
                                </div>
                            <?php    }
                            ?>







                        </div>






                    </div>
                </div>
            </div>

        </div>
    </div>









</div>



<script>
    window.onload = function() {


        $('#codigoProducto').on('keyup', function(event) {
            let inputValue = $(this).val().trim();

            // Si no es la tecla Enter, prevenimos el comportamiento por defecto
            if (event.key !== 'Enter') {
                event.preventDefault(); // Evitar que otras teclas procesen su efecto
            } else if (inputValue !== '') {
                // Solo llamamos a la función si se presiona Enter y el input no está vacío
                consultaProducto();
            }
        });
    };







    function consultaProducto() {
        let inputValue = $('#codigoProducto').val();

        if (inputValue.trim() !== '') {
            $.get('index.php?r=productos/get-producto&codigo=' + inputValue)
                .done(function(data) {
                    data = JSON.parse(data)
                    if (data.resultado) {
                        $('#nomProducto').val(data.data.pro_nombre);
                        $('#pvpProducto').val(data.data.pro_pvp);

                        $('#cantProducto').val(1);
                        $('#cantProducto').focus();

                    } else {
                        $('#nomProducto').val('');
                        $('#pvpProducto').val('');
                        $('#cantProducto').val();

                        Swal.fire({
                            title: "Oops...",
                            text: data.mensaje ?? 'Producto no encontrado',
                        });
                    }
                })
                .fail(function(xhr, status, error) {
                    console.error('Error en la solicitud:', error);
                });
        }
    }



    function consultaIdentificacion(input) {

        input.value = input.value.replace(/\D/g, '');
        let inputValue = $('#cliIdentificacion').val();
        let factura = ''

        if (inputValue.trim() !== '') {

            $.get('index.php?r=clientes/get-cliente&identificacion=' + inputValue + '&factura=' + factura)
                .done(function(data) {
                    data = JSON.parse(data)
                    console.log(data)
                    if (data.resultado) {

                        $('#cliNombre').val(data.data.cli_nombre)
                        $('#cliEmail').val(data.data.cli_correo)
                        $('#cliFono').val(data.data.cli_telefono)
                        $('#cliDireccion').val(data.data.cli_direccion)
                        $('#cliCelular').val(data.data.cli_celular)

                    } else {
                        /*$('#cliNombre').val('')
                        $('#cliEmail').val('')
                        $('#cliFono').val('')
                        $('#cliCelular').val('')
                        $('#cliDireccion').val('')*/
                    }
                })
                .fail(function(xhr, status, error) {
                    // Manejar el error
                    console.error('Error en la solicitud:', error);
                });
        }
    }


    function registrar() {
        let identificacion = $('#cliIdentificacion').val().trim()
        let nombre = $('#cliNombre').val().trim()
        let email = $('#cliEmail').val().trim()
        let fono = $('#cliFono').val().trim()
        let celular = $('#cliCelular').val().trim()
        let direccion = $('#cliDireccion').val().trim()
        let factura = ''


        if (identificacion.length !== 10 && identificacion.length !== 13) {
            return false;
        }


        //guardamos el cliente
        if (identificacion.trim() !== '' && nombre.trim() !== '') {
            $.get(`index.php?r=clientes/guarda-cliente&identificacion=${identificacion}&nombre=${nombre}&email=${email}&direccion=${direccion}&fono=${fono}&celular=${celular}&factura=${factura}`)
                .done(function(data) {
                    data = JSON.parse(data)
                    console.log(data);

                    if (data.transaccion) {


                        //almacenamos el pedido
                        guardaSeparado(data.idCliente)


                    } else {
                        Swal.fire({
                            title: "Oops...",
                            text: data.error ?? 'No pudimos procesar tu solicitud',
                        });
                    }
                })
                .fail(function(xhr, status, error) {
                    // Manejar el error
                    console.error('Error en la solicitud:', error);
                });
        } else {
            Swal.fire({
                title: "Oops...",
                text: data.error ?? 'Por favor ingresa todos los datos solicitados',
            });
        }
    }



    function guardaSeparado(idCliente) {


        let codigoProd = $('#codigoProducto').val().trim()
        let nombreProd = $('#nomProducto').val().trim()
        let precio = $('#pvpProducto').val().trim()


        if (codigoProd.trim() !== '' && precio.trim() !== '') {
            $.get(`index.php?r=separados/registrar-separado&idCliente=${idCliente}&producto=${codigoProd}`)
                .done(function(data) {
                    data = JSON.parse(data)
                    console.log(data);

                    if (data.transaccion) {


                        Swal.fire({
                            text: 'Se registró el separado con éxito. No olvides registrar los abonos. ',
                            icon: 'success'
                        }).then((result) => {
                            if (result.isConfirmed || result.isDismissed) {
                                window.location.replace('index.php?r=separados/update&id=' + data.id);
                            }
                        });


                    } else {
                        Swal.fire({
                            title: "Oops...",
                            text: data.error ?? 'No pudimos procesar tu solicitud',
                        });
                    }
                })
                .fail(function(xhr, status, error) {
                    // Manejar el error
                    console.error('Error en la solicitud:', error);
                });
        } else {
            Swal.fire({
                title: "Oops...",
                text: data.error ?? 'Por favor ingresa todos los datos solicitados',
            });
        }
    }
</script>