<?php

use app\models\Clientes;
use app\models\Parametros;
use app\models\Separados;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var app\models\SeparadosSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Separados';
$this->params['breadcrumbs'][] = $this->title;
?>

<style>
    .green {
        color: green;
    }
</style>
<div class="separados-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Agregar separado', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); 
    ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],


            'id',
            'fecha',
            [
                'attribute' => 'cli_id',
                'value' => function ($model) {
                    $cliente = Clientes::find()->where(['cli_id' => $model->cli_id])->one();
                    return $cliente->cli_identificacion ?? '';
                },


            ],
            'estado',

            [
                'attribute' => 'estado',
                'format' => 'raw',
                'value' => function ($model) {

                    if ($model->estado == Parametros::SEP_PAGADO) {
                        return "<span class='badge bg-success '>Pagado</span>";
                    } else {
                        return  "<span class='badge bg-light text-dark '>Pendiente</span>";;
                    }
                },
                'filter' => [Parametros::SEP_PAGADO => 'Pagado', Parametros::SEP_PENDIENTE => 'Pendiente']

            ],

            [
                'attribute' => 'total',
                'value' => function ($model) {
                    return "$" . number_format($model->total, 2);
                },
            ],

            [
                'attribute' => 'saldo',
                'value' => function ($model) {
                    return "$" . number_format($model->saldo, 2);
                },
            ],







            //'created_by',
            //'updated_by',
            //'pro_id',
            //'total',
            //'cantidad',
            [
                'class' => ActionColumn::className(),
                'template' => ' {update} {delete}', // Muestra solo los botones que quieras
                'buttons' => [
                    'update' => function ($url, $model, $key) {
                        // Cambia el ícono de editar
                        return Html::a('<i class="bx bx-money bx-sm"></i>', $url, [
                            'title' => Yii::t('app', 'Update'),
                            'class' => ' green', // Otras clases CSS si quieres
                        ]);
                    },
                ],
                'urlCreator' => function ($action, Separados $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                }
            ],
        ],
    ]); ?>


</div>