<?php

use app\models\Empresa;
use app\models\Marcas;
use app\models\Productos;
use yii\helpers\Html;

$empresa = Empresa::find()->where(['codigo' => 'miller'])->one();
$productos = Productos::find()->all();
?>


<style>
    .etiqueta {
        font-weight: 120;
        font-size: 30px;
        background-color: #f1f1f1;
        padding: 10px 35px;
        border-radius: 55px;
        color: grey
    }


    .card_servicio {
        border: 1px solid white;
        border-radius: 25px;
        padding: 25px 25px 8px 25px;
        width: 22%;
        background-color: #ffffffd9;
    }



    @media (max-width: 767px) {
        .card_servicio {
            width: 80%;
            margin: auto;
            margin-bottom: 20px;
        }
    }

    .card_contacto {
        border: 1px solid gray;
        border-radius: 25px;
        padding: 25px;
        background-color: #ffffff;
        margin: 15px;
        width: 80%;
        margin: auto;
    }


    .btn-card {
        padding: 6px;
        border: none;
        border-radius: 15px;
        color: white;
        background-color: #1770e8;

    }


    .btn-card:hover {
        padding: 6px;
        border: none;
        border-radius: 15px;
        color: white;
        background-color: #1770e8;

    }


    @media (max-width: 767px) {
        .display-2 {
            text-align: center;
        }

        .display-3 {
            text-align: center;
        }
    }
</style>


<div class="pt-5 pb-5" style="background-image: url('<?= Yii::$app->urlManager->baseUrl . '/uploads/images/' . $empresa->imagen_banner; ?>'); background-repeat: no-repeat; background-size: cover;">


    <div class="container">
        <div class="row">
            <div class="col-md-4" style="display: flex; flex-direction: column;justify-content: center;">
                <img style=" display: block; width: 40%; " class="img-fluid" src="<?= Yii::$app->urlManager->baseUrl . '/uploads/images/' . $empresa->logotipo ?>" alt="">
                <h1 style="" class="display-4">Tecnicentro <br> del Calefón</h1>
                <p style=" font-weight: 100; text-align: justify;"><?= $empresa->descripcion_banner ?></p>


                <br>
                <div class="d-none d-md-block">
                    <a href="index.php?r=productos/ver-catalogo" class="btn btn-primary btn-lg heartbeat-button" style="border-radius: 25px; z-index: 20;background-color: orange; color:#fff">Explora nuestro catálogo</a>
                </div>
            </div>


        </div>
    </div>
</div>


<div class="row">
    <div class="col-md-12">
        <img style=" display: block; width: 100%; " class="img-fluid" src="<?= Yii::$app->urlManager->baseUrl . '/uploads/images/' . $empresa->marcas ?>" alt="">
    </div>
</div>




<section style=" background-color: #e5e5e5;">
    <div class=" container-fluid">
        <div class="container">
            <div class="row pt-5 pb-5" style="display: flex; justify-content: space-around;">


                <div class=" card_servicio">
                    <h3 style="color: #37517e;">Venta</h3>
                    <p style="font-size: 14px;"><?= $empresa->venta ?></p>
                    <hr>
                    <button type="button" style="width: 100%;" class="btn btn-success" onclick="enviarWhatsApp('venta')"><i class="fa-brands fa-whatsapp"></i> Contactar</button>
                    <br><br>
                </div>

                <div class=" card_servicio">
                    <h3 style="color: #37517e;">Mantenimiento</h3>
                    <p style="font-size: 14px;"><?= $empresa->mantenimiento ?></p>
                    <hr>
                    <a onclick="solicitarServicio()" type="button" style="width: 100%;" class="btn btn-secondary">Solicitar</a>
                    <br><br>

                </div>


                <div class=" card_servicio">
                    <h3 style="color: #37517e;">Reparación</h3>
                    <p style="font-size: 14px;"><?= $empresa->reparacion ?></p>
                    <hr>
                    <button type="button" style="width: 100%;" class="btn btn-secondary">Solicitar</button>
                    <br><br>
                </div>



            </div>
        </div>
    </div>

</section>




<section id="ofertaAcademica" class="d-none d-md-block" style="background-color: #fff;">
    <div class="container">
        <div class="row" style="padding-top: 60px; padding-bottom: 20px;">

            <div class="row">
                <!--Carreras-->
                <div class="col-md-12">
                    <div class="row py-4">

                        <div class="col-md-12" style="display: flex; flex-direction: row; align-items: center;">

                            <img style="max-width: 10%;" class="img-fluid" src="data:image/png;base64,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" alt="">

                            <div>
                                <h2 style="color: #37517e;" class="display-4">Tenemos todo lo que necesitas</h2>
                                <p>Trabajamos con las mejores marcas y siempre a los mejores precios</p>
                            </div>

                        </div>


                        <div class="row">
                            <div id="carouselExampleControls" class="carousel carousel-dark slide" data-bs-ride="carousel">

                                <div class="carousel-inner" style="padding-left: 15px; padding-right: 15px;">
                                    <?php
                                    $chunks = array_chunk($productos, 4);
                                    foreach ($chunks as $key => $chunk) {
                                        $activeClass = $key === 0 ? 'active' : ''; // Establecer la primera fila como activa

                                        // Generar una nueva carousel-item para cada trozo de 3 elementos
                                        echo '<div class="carousel-item ' . $activeClass . '">
                                            <div class="row">';

                                        foreach ($chunk as $producto) {
                                            // Generar cada elemento de la fila
                                            $precioNeto = $producto['pro_pvp'];
                                            $precioFinal = $producto['pro_pvp'];
                                            $marcaProd = '';

                                            if (!empty($producto['pro_marca'])) {
                                                $marca = Marcas::find()->where(['mar_id' => $producto['pro_marca']])->one();
                                                $marcaProd =  $marca['mar_nombre'];
                                            }


                                            if (isset($producto['aplicaDescuento']) && $producto['aplicaDescuento'] && !empty($producto['porcDescuento'])) {
                                                $precioFinal = $precioNeto - ($precioNeto / 100 * floatval($producto['porcDescuento']));
                                            }


                                            if (isset($producto['aplicaDescuento']) && $producto['aplicaDescuento']) {
                                                echo '<div class="col-md-3" style="padding: 15px;">
                                                
                                            <div class="card h-100">
                                            <div class="card-body d-grid">
                                            <div style="position: absolute; right: 0px; top: 0px; background-color: #1770ac; color: white; border-radius: 50%; padding: 10px; display: flex; align-items: center; justify-content: center;">
                                                <h5>' . $producto['porcDescuento'] . '%</h5>
                                                <span style="font-size: 13px">Dscto</span>
                                            </div>
                                            <img style="border-radius: 10px; width: 100%" class="card-img-top img-fluid carrera-img" src="' . Yii::$app->urlManager->baseUrl . '/uploads/images/' . $producto['pro_foto'] . '" alt="">
                                            <span style="text-align:center; font-size:20px;margin-bottom:8px; font-weight:500; color:#1770ac">Precio: $' . number_format($precioFinal, 2) . '</span>
        
                                                <span style="text-align:center; font-size:16px;margin-bottom:8px; font-weight:500; color:gray">' . $producto['producto'] . '</span>
                                                <span style="text-align:center; font-size:13px;margin-bottom:8px; font-weight:500; background-color: #f1f1f1; border-radius:20px; color:gray; display: inline-block">' . $producto['marca'] . '</span>
                                                
                                                    ' . Html::a(
                                                    'Ver detalle',
                                                    ['productos/ver-producto', 'id' => $producto['id']],
                                                    ['class' => ' btn-card btn-sm btn-block']
                                                ) . '
                                                </div>
                                            </div>
                                        </div>';
                                            } else {
                                                echo '<div class="col-md-3" style="padding: 15px;">
                                                
                                            <div class="card h-100">
                                            <div class="card-body d-grid">
                                         
                                            <img style="border-radius: 10px; width: 100%" class="card-img-top img-fluid carrera-img" src="' . Yii::$app->urlManager->baseUrl . '/uploads/images/' . $producto['pro_foto'] . '" alt="">
                                            <span style="text-align:center; font-size:20px;margin-bottom:8px; font-weight:500; color:#1770ac">Precio: $' . number_format($precioFinal, 2) . '</span>
        
                                                <span style="text-align:center; font-size:16px;margin-bottom:8px; font-weight:500; color:gray">' . $producto['pro_nombre'] . '</span>
                                                <span style="text-align:center; font-size:13px;margin-bottom:8px; font-weight:500; display: inline-block">' . $marcaProd . '</span>
                                                
                                                    ' . Html::a(
                                                    'Ver detalle',
                                                    ['productos/ver-producto', 'id' => $producto['pro_id']],
                                                    ['class' => 'btn btn-card btn-sm btn-block']
                                                ) . '
                                                </div>
                                            </div>
                                        </div>';
                                            }
                                        }

                                        // Calcular el número de tarjetas adicionales necesarias para completar la fila
                                        $remainingCards = count($chunk);
                                        $remainingCols = 4 - $remainingCards;

                                        // Mostrar columnas vacías si es necesario
                                        if ($remainingCols > 0) {
                                            for ($i = 0; $i < $remainingCols; $i++) {
                                                echo '<div class="col-md-3"></div>';
                                            }
                                        }

                                        echo '</div></div>';
                                    }
                                    ?>

                                </div>


                                <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="prev" style="width: auto;">
                                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Previous</span>
                                </button>
                                <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="next" style="width: auto">
                                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Next</span>
                                </button>
                            </div>
                        </div>

                    </div>
                </div>




            </div>

        </div>

        <div class="d-none d-md-block text-center">
            <a href="index.php?r=productos/ver-catalogo" class="btn btn-primary btn-lg heartbeat-button" style="border-radius: 25px; z-index: 20;background-color: #F3910A;">Explora nuestro catálogo</a>
        </div>

    </div>
</section>




<!-- INSTITUTO -->
<section class=" pb-5 pt-5 " id="cursosEventos" style="margin-top:75px; background-image: url('<?= Yii::$app->urlManager->baseUrl . '/uploads/images/fondoBase.png' ?>');">

    <div class="container">
        <div class="row" style="display: flex; align-items: center; padding-top: 30px; padding-bottom: 30px;  color:grey">

            <div class="col-md-4">

                <a target="_blank" href="<?= $empresa->googlemaps ?>">
                    <img style="display: block; margin: auto; width:90%" class="img-fluid" src="<?= Yii::$app->urlManager->baseUrl . '/uploads/images/' . $empresa->mapa ?>" alt="">
                </a>
                <br>
                <p class="text-center text-white" style="font-size: 13px;">Presiona sobre el mapa para ver la ubicación</p>


            </div>

            <div class="col-md-8">
                <h2 style="color: #ffffff;" class="display-3">Contáctanos</h2>
                <p style="color: white;">
                    ¿Tienes alguna inquietud? No dudes en contactarnos, estamos listos para atenderte.
                </p>
                <br>

                <div class="card_contacto">

                    <div class="row">
                        <div class="col-md-4">
                            <img style="display: block; margin: auto; " class="img-fluid" src="<?= Yii::$app->urlManager->baseUrl . '/uploads/images/contactanos.png' ?>" alt="">
                        </div>
                        <div class="col-md-8">
                            <h3 style="color:#08326f"> Horario de atención:</h3>


                            <?php
                            $horarios = explode(',', $empresa->horario_atencion);

                            foreach ($horarios as $horario) { ?>
                                <p><?= $horario ?></p>
                            <?php }
                            ?>


                            <hr>

                            <p>Llámanos al: <?= $empresa->telefonos ?></p>
                        </div>
                    </div>



                </div>


            </div>



        </div>
    </div>
    </div>

</section>



<script>
    function enviarWhatsApp(tipo) {
        let mensaje = 'Hola deseo más información por favor';


        var url = "https://api.whatsapp.com/send?phone=593" + <?= $empresa->whatsapp ?> + "&text=" + encodeURIComponent(mensaje);
        window.open(url, '_blank');
    }
</script>