<?php

use app\models\Carreras;
use app\models\Departamentos;
use app\models\Eventos;
use app\models\Instituto;
use yii\helpers\Html;



?>

<!-- ESTILOS  -->

<style>
    .carrera-img:hover {
        filter: opacity(.6);
    }

    .heartbeat-button {
        font-size: 18px;
        padding: 10px 20px;
        border: none;
        background-color: #007bff;
        color: #fff;
        border-radius: 5px;
        cursor: pointer;
        animation: heartbeat 2s infinite ease-in-out;
        background-color: #1458A4;
    }

    .nav-link {
        color: white;
    }

    .nav-link:hover {
        font-weight: 500;
        color: white;
    }

    .nav-link2 {
        color: grey;
        text-decoration: none;
        font-size: 13px;
    }

    .logos img {
        width: 85%;
        display: block;
        margin: auto;
    }

    .accordion-button:not(.collapsed) {
        color: white;
        background-color: #1458A4;
    }

    @keyframes heartbeat {

        0%,
        100% {
            transform: scale(1);
        }

        50% {
            transform: scale(1.1);
        }
    }

    .carouselExampleControls {
        padding: 5%;
    }
</style>

<!-- FIN ESTILOS  -->



<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>


<!-- MENU PRINCIPAL -->
<nav class="navbar navbar-expand-lg navbar-dark fixed-top" style="background-color: #193C78;">
    <div class="container-fluid">
        <a class="navbar-brand" href="#"><?= $instituto->nombre ?></a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <ul class="navbar-nav ms-auto">

                <!-- ITEMS DE MENU -->

                <li class="nav-item">
                    <a href="#Inicio" class="nav-link">Inicio</a>
                </li>
                <li class="nav-item">
                    <a href="#ofertaAcademica" class="nav-link">Oferta académica</a>
                </li>
                <li class="nav-item">
                    <a href="#cursosEventos" class="nav-link">Cursos y eventos</a>
                </li>
                <li class="nav-item">
                    <a href="#departamentos" class="nav-link">Departamentos</a>
                </li>
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                        Servicios
                    </a>
                    <ul class="dropdown-menu" aria-labelledby="navbarDropdown" style="padding: 4px; padding-bottom: 12px;">
                        <li>
                            <a href="https://www.ucuenca.edu.ec/servicios/biblioteca/" class="nav-link2">Biblioteca U. Cuenca</a>
                        <li>
                            <hr>
                        </li>
                </li>
                <li>
                    <a href="https://www.uasb.edu.ec/biblioteca/" class="nav-link2">Biblioteca U. Andina Simón Bolivar</a>
                </li>

            </ul>
            </li>
            <li class="nav-item">
                <a href="#" class="nav-link">Contáctanos</a>
            </li>
            <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                    Ingresar
                </a>
                <ul class="dropdown-menu" aria-labelledby="navbarDropdown" style="padding: 4px; padding-bottom: 12px;">
                    <li>
                        <a href="https://site2.q10.com/login?ReturnUrl=%2F&aplentId=e5333a78-4bdb-44d8-b4a3-714ff3c7546e" class="nav-link2">Plataforma académica</a>
                    </li>
                    <hr>

                </ul>
            </li>

            <!-- FIN ITEMS DE MENU -->

            </ul>

        </div>
    </div>
</nav>
<div>
    <svg id="wave" style="transform:rotate(180deg); transition: 0.3s" viewBox="0 0 1440 240" version="1.1" xmlns="http://www.w3.org/2000/svg">
        <defs>
            <linearGradient id="sw-gradient-0" x1="0" x2="0" y1="1" y2="0">
                <stop stop-color="#193C78" offset="0%"></stop>
                <stop stop-color="#193C78" offset="100%"></stop>
            </linearGradient>
        </defs>
        <path style="transform:translate(0, 0px); opacity:1" fill="url(#sw-gradient-0)" d="M0,72L26.7,60C53.3,48,107,24,160,16C213.3,8,267,16,320,36C373.3,56,427,88,480,92C533.3,96,587,72,640,80C693.3,88,747,128,800,152C853.3,176,907,184,960,180C1013.3,176,1067,160,1120,152C1173.3,144,1227,144,1280,132C1333.3,120,1387,96,1440,72C1493.3,48,1547,24,1600,12C1653.3,0,1707,0,1760,32C1813.3,64,1867,128,1920,136C1973.3,144,2027,96,2080,92C2133.3,88,2187,128,2240,124C2293.3,120,2347,72,2400,72C2453.3,72,2507,120,2560,124C2613.3,128,2667,88,2720,92C2773.3,96,2827,144,2880,168C2933.3,192,2987,192,3040,192C3093.3,192,3147,192,3200,172C3253.3,152,3307,112,3360,100C3413.3,88,3467,104,3520,116C3573.3,128,3627,136,3680,152C3733.3,168,3787,192,3813,204L3840,216L3840,240L3813.3,240C3786.7,240,3733,240,3680,240C3626.7,240,3573,240,3520,240C3466.7,240,3413,240,3360,240C3306.7,240,3253,240,3200,240C3146.7,240,3093,240,3040,240C2986.7,240,2933,240,2880,240C2826.7,240,2773,240,2720,240C2666.7,240,2613,240,2560,240C2506.7,240,2453,240,2400,240C2346.7,240,2293,240,2240,240C2186.7,240,2133,240,2080,240C2026.7,240,1973,240,1920,240C1866.7,240,1813,240,1760,240C1706.7,240,1653,240,1600,240C1546.7,240,1493,240,1440,240C1386.7,240,1333,240,1280,240C1226.7,240,1173,240,1120,240C1066.7,240,1013,240,960,240C906.7,240,853,240,800,240C746.7,240,693,240,640,240C586.7,240,533,240,480,240C426.7,240,373,240,320,240C266.7,240,213,240,160,240C106.7,240,53,240,27,240L0,240Z"></path>
    </svg>
</div>


<!-- HEADER -->
<header>
    <div class="container">
        <div class="row" style="margin-top: 30px;">

            <div class="col-md-5" style="display: flex; flex-direction: column;justify-content: center;">
                <h2 class="display-4">¡Profesionales que piensan <span style="color: orangered; font-family: 'Dancing Script'; font-size: 70px;">diferente!</span> </h2>
                <p><?= $instituto->descripcion_banner ?></p>
                <br>
                <div class="d-none d-md-block">
                    <a class="btn btn-primary btn-lg heartbeat-button" style="border-radius: 25px; z-index: 20;">Explora nuestras carreras</a>
                </div>

            </div>

            <div class="col-md-7" style="padding-left: 0px; padding-right: 0px; ">
                <div style="width: 100%;">
                    <div style="position: relative; padding-bottom: 56.25%; padding-top: 0; height: 0;"><iframe title="Instituto INAN" frameborder="0" width="1200" height="675" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;" src="https://view.genial.ly/6536db3b4d4ce90010004bb1" type="text/html" allowscriptaccess="always" allowfullscreen="true" scrolling="yes" allownetworking="all"></iframe> </div>
                </div>

                <div style="margin-top: 15px; padding: 10px;" class="d-block d-md-none">
                    <a class="btn btn-primary btn-lg " style="border-radius: 25px; z-index: 20; display: block; margin: auto;">Explora nuestras carreras</a>
                </div>
            </div>

        </div>
    </div>
</header>




<!--  INAN EN NUMEROS -->

<section class="d-none d-md-block">

    <div class="container">
        <div class="row" style="background-color: #fff; text-align: center; padding-top: 30px; padding-bottom: 30px;  margin-top: 60px;">

            <div class="col-md-3">
                <span style="font-weight: 120; font-size: 30px; background-color: #f1f1f1; padding: 10px 35px; border-radius: 55px; color: grey"><?= $instituto->num_sedes ?></span>
            </div>

            <div class="col-md-4">
                <span style="font-weight: 120; font-size: 30px; background-color: #f1f1f1; padding: 10px 35px; border-radius: 55px; color: grey"><?= $instituto->num_carreras ?></span>
            </div>

            <div class="col-md-4">
                <span style="font-weight: 120; font-size: 30px; background-color: #f1f1f1; padding: 10px 35px; border-radius: 55px; color: grey"><?= $instituto->num_graduados ?></span>
            </div>


        </div>
    </div>

</section>



<!-- CARRERAS -->
<section id="ofertaAcademica" class="d-none d-md-block">
    <div class="container">
        <div class="row" style="padding-top: 60px; padding-bottom: 20px;">

            <div class="row">
                <div class="col-md-4">
                    <img class="img-fluid" src="https://img.freepik.com/foto-gratis/estudiante-estudiante-afortunado_1368-9248.jpg" alt="">
                </div>

                <!--Carreras-->
                <div class="col-md-8">
                    <div class="row py-4">
                        <div class="col-md-12">
                            <h2 class="display-4">Oferta <span style="color: orangered">académica</span></h2>
                            <p>
                                <?= $instituto->frase_oferta_academica ?>
                            </p>
                        </div>


                        <div class="row">
                            <div id="carouselExampleControls" class="carousel carousel-dark slide" data-bs-ride="carousel">

                                <div class="carousel-inner" style="padding-left: 15px; padding-right: 15px;">
                                    <?php
                                    $chunks = array_chunk($carreras, 3);
                                    foreach ($chunks as $key => $chunk) {
                                        $activeClass = $key === 0 ? 'active' : ''; // Establecer la primera fila como activa

                                        // Generar una nueva carousel-item para cada trozo de 3 elementos
                                        echo '<div class="carousel-item ' . $activeClass . '">
                                            <div class="row">';

                                        foreach ($chunk as $carrera) {
                                            // Generar cada elemento de la fila
                                            echo '<div class="col-md-4" style="padding: 15px">
                                                <div class="card h-100">
                                                    <img style="border-radius: 10px; width: 100%" class="card-img-top img-fluid carrera-img" src="' . Yii::$app->urlManager->baseUrl . '/uploads/images/' . $carrera['img_tarjeta'] . '" alt="">
                                                    <div class="card-body d-grid">
                                                        ' . Html::a(
                                                'Más información',
                                                ['carreras/ver-carrera', 'codigo' => $carrera['codigo']],
                                                ['class' => 'btn btn-primary btn-block']
                                            ) . '
                                                    </div>
                                                </div>
                                            </div>';
                                        }

                                        // Calcular el número de tarjetas adicionales necesarias para completar la fila
                                        $remainingCards = count($chunk);
                                        $remainingCols = 3 - $remainingCards;

                                        // Mostrar columnas vacías si es necesario
                                        if ($remainingCols > 0) {
                                            for ($i = 0; $i < $remainingCols; $i++) {
                                                echo '<div class="col-md-4"></div>';
                                            }
                                        }

                                        echo '</div></div>';
                                    }
                                    ?>

                                </div>


                                <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="prev" style="width: auto;">
                                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Previous</span>
                                </button>
                                <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls" data-bs-slide="next" style="width: auto">
                                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                    <span class="visually-hidden">Next</span>
                                </button>
                            </div>
                        </div>

                    </div>
                </div>




            </div>

        </div>
    </div>
</section>






<!-- CARRERAS -->
<section id="ofertaAcademica" class="d-block d-md-none">
    <div class="container">
        <div class="row" style="padding:0px;  padding-top: 30px; padding-bottom: 5px;">

            <!--Carreras-->
            <div class="col-md-12">
                <div class="row pt-2">
                    <div class="col-md-12">
                        <h2 class="display-4">Oferta <span style="color: orangered">académica</span></h2>
                        <p>
                            <?= $instituto->frase_oferta_academica ?>
                        </p>
                    </div>

                    <div class="row" style="padding: 15px; margin:0px">
                        <div id="carouselExampleControls" class="carousel carousel-dark slide" data-bs-ride="carousel">
                            <div class="carousel-inner" style="padding-left: 15px; padding-right: 15px;">
                                <?php
                                foreach ($carreras as $key => $carrera) {
                                    $activeClass = $key === 0 ? 'active' : '';

                                    echo '<div class="carousel-item ' . $activeClass . '">
                                                <div class="row">
                                                    <div class="col-12 col-sm-6 col-md-4 mx-auto" style="padding: 15px">
                                                        <div class="card h-100">
                                                            <img style="border-radius: 10px; width: 100%" class="card-img-top img-fluid carrera-img" src="' . Yii::$app->urlManager->baseUrl . '/uploads/images/' . $carrera['img_tarjeta'] . '" alt="">
                                                            <div class="card-body d-grid">
                                                                ' . Html::a(
                                        'Más información',
                                        ['carreras/ver-carrera', 'codigo' => $carrera['codigo']],
                                        ['class' => 'btn btn-primary btn-block']
                                    ) . '
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>';
                                }
                                ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div>
        <img src="https://lordicon.com/icons/wired/gradient/1367-swipe-left.gif" style="width: 60px; display: block; margin: auto;" alt="">
    </div>
</section>



<section style="margin-top: 40px; background-color: #f1f1f1;">

    <div class="container">
        <div class="row" style=" text-align: center; padding-top: 60px; padding-bottom: 50px; margin-top: 25px; ">
            <div class="col-md-12">
                <h3 class="display-6">Conoce a nuestros <span style="color: orangered;">partners</span></h3>
                <p style="margin-bottom: 20px;"><?= $instituto->frase_partners ?></p>
            </div>

            <div class="mt-4">
                <img style="max-height: 60px; margin-right: 40px;" class="img-fluid" src="https://biociencias.es/wp-content/uploads/2021/10/Logo-CEEBI-horizontal-sin-fondo.png" alt="">
                <img style="max-height: 60px; margin-right: 40px;" class="img-fluid" src="https://pngimg.com/d/mysql_PNG6.png" alt="">
                <img style="max-height: 60px; margin-right: 40px;" class="img-fluid" src="https://upload.wikimedia.org/wikipedia/commons/thumb/4/49/Banco_Guayaquil_%282020%29.svg/2560px-Banco_Guayaquil_%282020%29.svg.png" alt="">
                <img style="max-height: 60px; margin-right: 40px;" class="img-fluid" src="https://logotipoz.com/wp-content/uploads/2021/10/version-horizontal-large-logo-mercado-pago.webp" alt="">
            </div>


        </div>

    </div>


</section>


<!-- INSTITUTO -->
<section style="margin-top: 100px">

    <div class="container">
        <div class="row" style="padding-top: 30px; padding-bottom: 30px;  color:grey">

            <div class="col-md-6">
                <div class="rpw">
                    <div class="col-md-12" style="padding-left: 40px">
                        <img class="img-fluid" src="https://img.freepik.com/fotos-premium/hombre-mujer-joven-sentados-sillones-puf-azules-grises-sala-estar-u-otra-habitacion-jugar-videojuegos-aislados-blanco_385506-719.jpg" alt="">
                    </div>
                </div>
                <div class="row logos" style="display: flex; flex-direction: row;align-items: center;">
                    <div class="col- col-md-4">
                        <img class="img-fluid" src="https://www.ces.gob.ec/wp-content/uploads/2019/04/ces.png" alt="">
                    </div>
                    <div class="col-md-4">
                        <img class="img-fluid" src="https://apps.caces.gob.ec/idp/resources/images/iconos-general/LogoCaces.png" alt="">
                    </div>
                    <div class="col-md-4">
                        <img class="img-fluid" src="https://ecuadorec.com/wp-content/uploads/2016/06/Secretar%C3%ADa-de-Educaci%C3%B3n-Superior-Ciencia-Tecnolog%C3%ADa-e-Innovaci%C3%B3n-SENESCYT.jpg" alt="">
                    </div>
                </div>

            </div>

            <div class="col-md-6">

                <h2 class="display-4">Nuestro <span style="color: orangered">instituto</span> </h2><br>
                <div class="accordion" id="accordionExample">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
                                Nosotros
                            </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p><?= $instituto->nosotros ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                Misión
                            </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p><?= $instituto->mision ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                Visión
                            </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <p>
                                <p><?= $instituto->vision ?></p>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>

            </div>

        </div>
    </div>

</section>





<!-- CURSOS Y EVENTOS -->
<section class="d-none d-md-block" id="cursosEventos" style="margin-top: 55px; background-color: #f1f1f1;">

    <div class="container">
        <div class="row" style="padding-top: 60px; padding-bottom: 20px; ">
            <div class="col-md-12">
                <h2 class="display-4">Cursos y <span style="color: orangered">eventos</span> </h2>
                <p>
                    <?= $instituto->frase_eventos ?>
                </p>
            </div>

            <div class="col-md-12">
                <div class="row py-4">
                    <div class="row">
                        <div id="carouselExampleControls2" class="carousel carousel-dark slide" data-bs-ride="carousel">

                            <div class="carousel-inner" style="padding-left: 15px; padding-right: 15px;">
                                <?php
                                $chunks2 = array_chunk($eventos, 3);
                                foreach ($chunks2 as $key => $chunk) {
                                    $activeClass = $key === 0 ? 'active' : ''; // Establecer la primera fila como activa

                                    // Generar una nueva carousel-item para cada trozo de 3 elementos
                                    echo '<div class="carousel-item ' . $activeClass . '">
                                            <div class="row">';

                                    foreach ($chunk as $evento) { ?>

                                        <div class="col-md-4" style="padding: 10px 25px;">
                                            <div style="border: 1px solid #cfcfcf; border-radius: 10px; background-color: #fefbfb; padding: 13px;">

                                                <h5 class="mt-2 mb-3" style="color: dimgrey;"><?= $evento['evento'] ?></h5>
                                                <img style="border-radius: 10px; width: 100%; margin-bottom: 15px;" class="img-fluid carrera-img" src="<?= Yii::$app->urlManager->baseUrl . '/uploads/images/' . $evento['imagen'] ?>" alt="">

                                                <em style="font-size: 13px;"><?= $evento['fecha'] ?></em><br>
                                                <span style="font-size: 14px; color: grey;"><?= $evento['descripcion_corta'] ?></span>
                                                <div class="d-grid my-2">

                                                    <button type="button" class="btn btn-primary btn-sm" onclick="mostrarModal()">
                                                        Ver detalles
                                                    </button>
                                                </div>

                                            </div>

                                        </div>

                                <?php }

                                    // Calcular el número de tarjetas adicionales necesarias para completar la fila
                                    $remainingCards = count($chunks2);
                                    $remainingCols = 3 - $remainingCards;

                                    // Mostrar columnas vacías si es necesario
                                    if ($remainingCols > 0) {
                                        for ($i = 0; $i < $remainingCols; $i++) {
                                            echo '<div class="col-md-4"></div>';
                                        }
                                    }

                                    echo '</div></div>';
                                }
                                ?>

                            </div>


                            <button class="carousel-control-prev" type="button" data-bs-target="#carouselExampleControls2" data-bs-slide="prev" style="width: auto;">
                                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Previous</span>
                            </button>
                            <button class="carousel-control-next" type="button" data-bs-target="#carouselExampleControls2" data-bs-slide="next" style="width: auto">
                                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                <span class="visually-hidden">Next</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>


        </div>

    </div>


</section>




<!-- CARRERAS -->
<section class="d-block d-md-none" id="cursosEventos" style="margin-top: 55px; background-color: #f1f1f1;">
    <div class="container">
        <div class="row" style="padding:0px;  padding-top: 30px; padding-bottom: 5px;">


            <div class="col-md-12">
                <h2 class="display-4">Cursos y <span style="color: orangered">eventos</span> </h2>
                <p>
                    <?= $instituto->frase_eventos ?>
                </p>
            </div>

            <div class="col-md-12">
                <div class="row pt-2">


                    <div class="row" style="padding: 15px; margin:0px">
                        <div id="carouselExampleControls" class="carousel carousel-dark slide" data-bs-ride="carousel">
                            <div class="carousel-inner" style="padding-left: 15px; padding-right: 15px;">
                                <?php
                                foreach ($carreras as $key => $carrera) {
                                    $activeClass = $key === 0 ? 'active' : '';

                                    echo '<div class="carousel-item ' . $activeClass . '">
                                                <div class="row">
                                                    <div class="col-12 col-sm-6 col-md-4 mx-auto" style="padding: 15px">
                                                    <div class="col-md-4" style="">
                                            <div style="border: 1px solid #cfcfcf; border-radius: 10px; background-color: #fefbfb; padding: 13px;">

                                            <h5 class="mt-2 mb-3" style="color: dimgrey;">' . $evento['evento'] . '</h5>
                                            <img style="border-radius: 10px; width: 100%; margin-bottom: 15px;" class="img-fluid carrera-img" src="' . Yii::$app->urlManager->baseUrl . '/uploads/images/' . $evento["imagen"] . '" alt="">
                                            
                                            <em style="font-size: 13px;">' . $evento['fecha'] . '</em><br>
                                            <span style="font-size: 14px; color: grey;">' . $evento['descripcion_corta'] . '</span>
                                            <div class="d-grid my-2">

                                            <button type="button" class="btn btn-primary btn-sm" onclick="mostrarModal()">
                                                Ver detalles
                                            </button>
                                            </div>

                                            </div>
                                            
                                        </div>                                                        
                                                    </div>
                                                </div>
                                            </div>';
                                }
                                ?>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div>
        <img src="https://lordicon.com/icons/wired/gradient/1367-swipe-left.gif" style="width: 60px; display: block; margin: auto;" alt="">
    </div>
</section>


<!--  DEPARTAMENTOS  -->
<section id="departamentos">

    <div class="container">
        <div class="row" style="padding-top: 60px; padding-bottom: 20px;">
            <div class="col-md-12">
                <h2 class="display-4">Nuestros <span style="color: orangered">departamentos</span> </h2>
                <p>
                    <?= $instituto->frase_departamentos ?>
                </p>
            </div>

        </div>

        <div class="row">
            <?php
            foreach ($departamentos as $departamento) { ?>
                <div class="col-md-3" style="padding: 10px 20px;">

                    <div style="padding: 7px 18px; border:2px solid #f1f1f1; border-radius: 12px">
                        <h6 class="mt-2" style="color: dimgrey;"><?= $departamento['departamento'] ?></h6>
                        <span style="font-size: 14px; color: grey;text-align: justify"><?= $departamento['descripcion_corta'] ?></span>
                        <div class="d-grid my-2">
                            <button class="btn btn-primary btn-sm">
                                Más información
                            </button>
                        </div>
                    </div>

                </div>
            <?php    }
            ?>
        </div>
    </div>

</section>