<?php

use app\models\Solicitudes;
use app\models\User;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/** @var yii\web\View $this */
/** @var app\models\SolicitudesSearch $searchModel */
/** @var yii\data\ActiveDataProvider $dataProvider */

$this->title = 'Solicitudes';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="solicitudes-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Ingresar Solicitud', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); 
    ?>



    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">


                            <?= GridView::widget([
                                'dataProvider' => $dataProvider,
                                'filterModel' => $searchModel,
                                'columns' => [
                                    ['class' => 'yii\grid\SerialColumn'],

                                    // 'id',
                                    'fecha',
                                    'nombre',
                                    'celular',


                                    [
                                        'attribute' => 'tipo',
                                        'value' => function ($model) {
                                            return $model->tipo === 'mant' ? 'Mantenimiento' : 'Reparación';
                                        },
                                        'filter' => ['mant' => 'Mantenimiento', 'rep' => 'Reparación'], // Opcional, para agregar el filtro en el GridView
                                    ],


                                    //'comentario:ntext',
                                    //'dirección',
                                    //'respuesta:ntext',


                                    [
                                        'attribute' => 'estado',
                                        'format' => 'raw',
                                        'value' => function ($model) {
                                            if ($model->estado == 'Pendiente') {
                                                return  "<span class='badge bg-warning text-dark'>$model->estado</span>";
                                            } else {
                                                return  "<span class='badge bg-success '>$model->estado</span>";
                                            }
                                        },
                                        'filter' => ['Pendiente' => 'Pendiente', 'Resuelto' => 'Resuelto'], // Opcional, para agregar el filtro en el GridView
                                    ],

                                    [
                                        'attribute' => 'responsable',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->responsable])->one();
                                            return $user->nombre;
                                        },

                                    ],

                                    [
                                        'class' => 'yii\grid\ActionColumn',
                                        'urlCreator' => function ($action, $model, $key, $index, $column) {
                                            return \yii\helpers\Url::toRoute([$action, 'id' => $model->id]);
                                        },
                                        'visibleButtons' => [
                                            'delete' => function ($model, $key, $index) {
                                                $userModel = Yii::$app->user->identity;
                                                return !empty($userModel->rol) && $userModel->rol === 'superAdmin';
                                            },
                                            // Opcionalmente puedes también controlar otros botones:
                                            // 'update' => function ($model, $key, $index) { ... },
                                            // 'view' => function ($model, $key, $index) { ... },
                                        ],
                                    ]
                                    ,
                                ],
                            ]); ?>


                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>




</div>