<?php

use app\models\User;
use yii\helpers\Html;
use yii\widgets\DetailView;

/** @var yii\web\View $this */
/** @var app\models\Tipogastos $model */

$this->title = $model->tip_gasto_id;
$this->params['breadcrumbs'][] = ['label' => 'Tipogastos', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="tipogastos-view">



    <p>
        <?= Html::a('Actualizar', ['update', 'tip_gasto_id' => $model->tip_gasto_id], ['class' => 'btn btn-success btn-sm']) ?>
    </p>



    <div class="row">
        <div class="col-lg-12 mb-4 order-0">
            <div class="card">
                <div class="d-flex align-items-end row">
                    <div class="col-sm-12">
                        <div class="card-body">

                            <?= DetailView::widget([
                                'model' => $model,
                                'attributes' => [
                                    //       'tip_gasto_id',
                                    'tip_gasto_nombre',
                                    'created_at',
                                    'updated_at',
                                    [
                                        'attribute' => 'created_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->created_by])->one();
                                            return $user->nombre;
                                        },

                                    ],
                                    [
                                        'attribute' => 'updated_by',
                                        'value' => function ($model) {
                                            $user = User::find()->where(['id' => $model->updated_by])->one();
                                            return $user->nombre;
                                        },

                                    ]

                                ],
                            ]) ?>

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>





</div>