<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;

$this->title = '';
$this->params['breadcrumbs'][] = $this->title;
?>

<h1><?= Html::encode($this->title) ?></h1>

<?php $form = ActiveForm::begin(); ?>



<div class="row">


    <div class="col-md-6">

        <div class="card mb-4">
            <h5 class="card-header">Datos usuario</h5>
            <div class="card-body">
                <div>


                    <?= $form->field($model, 'id')->label('Identificación')->textInput(['autofocus' => true]) ?>



                    <?= $form->field($model, 'nombre') ?>


                    <?= $form->field($model, 'email') ?>



                </div>
            </div>
        </div>

    </div>




    <div class="col-md-6">

        <div class="card mb-4">
            <h5 class="card-header">Credenciales</h5>
            <div class="card-body">
                <div>


                    <?= $form->field($model, 'username')->label('Usuario') ?>



                    <?= $form->field($model, 'rol')->dropDownList([
                        'superAdmin' => 'Super administrador',
                        'vendedor' => 'Vendedor'
                    ]) ?>

                    <?= $form->field($model, 'estado')->dropDownList([
                        'A' => 'Activo',
                        'I' => 'Inactivo'
                    ]) ?>

                    <?= $form->field($model, 'password')->label('Contraseña')->passwordInput(['id' => 'user-password', 'style' => 'display:none']) ?>

                    <input type="checkbox" id="editarPass" name="editarPass">
                    <label for="editarPass">Editar contraseña</label>



                </div>
            </div>
        </div>

    </div>





</div>





<br>

<div class="form-group">
    <?= Html::submitButton('Actualizar', ['class' => 'btn btn-primary']) ?>
</div>

<?php ActiveForm::end(); ?>

<script>
    let passActual = '<?= $model->password ?>'

    document.getElementById("editarPass").addEventListener("change", function() {
        var elemento = document.getElementById("user-password");

        if (this.checked) {
            elemento.style.display = "block";
            elemento.value = "";
        } else {
            elemento.style.display = "none";
            elemento.value = passActual;
        }
    });
</script>